/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.util.Stack;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.spi.Tuple;
import org.drools.core.util.FastIterator;
import org.drools.core.util.debug.AbstractNetworkNodeVisitor;
import org.drools.core.util.debug.DefaultNodeInfo;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;

public class AccumulateNodeVisitor
extends AbstractNetworkNodeVisitor {
    public static final AccumulateNodeVisitor INSTANCE = new AccumulateNodeVisitor();

    protected AccumulateNodeVisitor() {
    }

    @Override
    protected void doVisit(NetworkNode node, Stack<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        AccumulateNode an = (AccumulateNode)node;
        DefaultNodeInfo ni = info.getNodeInfo(node);
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)info.getSession().getNodeMemory(an);
        ni.setMemoryEnabled(true);
        if (an.isObjectMemoryEnabled()) {
            ni.setFactMemorySize(memory.getBetaMemory().getRightTupleMemory().size());
        }
        if (an.isLeftTupleMemoryEnabled()) {
            ni.setTupleMemorySize(memory.getBetaMemory().getLeftTupleMemory().size());
            FastIterator it = memory.getBetaMemory().getLeftTupleMemory().fullFastIterator();
            int i = 0;
            Tuple leftTuple = BetaNode.getFirstTuple(memory.getBetaMemory().getLeftTupleMemory(), it);
            while (leftTuple != null) {
                AccumulateNode.AccumulateContext ctx = (AccumulateNode.AccumulateContext)leftTuple.getContextObject();
                if (ctx != null) {
                    ++i;
                }
                leftTuple = (Tuple)it.next(leftTuple);
            }
            ni.setCreatedFactHandles(i);
        }
    }
}

