/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.metrics.MetricsConfig;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.MetricsServlet;
import org.apache.spark.metrics.sink.PrometheusServlet;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.metrics.source.StaticSources$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\tea!B\u0016-\u00019\"\u0004\u0002C!\u0001\u0005\u000b\u0007I\u0011A\"\t\u0011=\u0003!\u0011!Q\u0001\n\u0011C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006+\u0002!IA\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002/\t\u000f}\u0003!\u0019!C\u0005A\"1q\u000e\u0001Q\u0001\n\u0005Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001d\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\tY\u0001\u0001Q\u0001\nqD\u0011\"!\u0004\u0001\u0001\u0004%I!a\u0004\t\u0013\u0005]\u0001\u00011A\u0005\n\u0005e\u0001\u0002CA\u0013\u0001\u0001\u0006K!!\u0005\t\u0013\u0005\u001d\u0002\u00011A\u0005\n\u0005%\u0002\"CA\u001c\u0001\u0001\u0007I\u0011BA\u001d\u0011!\ti\u0004\u0001Q!\n\u0005-\u0002\"CA \u0001\u0001\u0007I\u0011BA!\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0015BA\"\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002|!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAK\u0001\u0011\u0005\u00111\u0013\u0005\t\u0003/\u0003A\u0011\u0001\u0018\u0002\u001a\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t\u0019\r\u0001C\u0005\u0003'Cq!!2\u0001\t\u0013\t\u0019j\u0002\u0005\u0002H2B\tALAe\r\u001dYC\u0006#\u0001/\u0003\u0017Da!V\u0011\u0005\u0002\u00055\u0007\"CAhC\t\u0007I\u0011AAi\u0011!\t\u0019/\tQ\u0001\n\u0005M\u0007\"CAsC\t\u0007I\u0011AAi\u0011!\t9/\tQ\u0001\n\u0005M\u0007\u0002CAuC\u0001\u0006I!a;\t\u0011\u0005u\u0018\u0005)A\u0005\u0003\u007fDqA!\u0002\"\t\u0003\u00119\u0001C\u0004\u0003\u0012\u0005\"\tAa\u0005\u0003\u001b5+GO]5dgNK8\u000f^3n\u0015\tic&A\u0004nKR\u0014\u0018nY:\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c2\u0001A\u001b<!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fMB\u0011AhP\u0007\u0002{)\u0011aHL\u0001\tS:$XM\u001d8bY&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003!Ign\u001d;b]\u000e,7\u0001A\u000b\u0002\tB\u0011Q\t\u0014\b\u0003\r*\u0003\"aR\u001c\u000e\u0003!S!!\u0013\"\u0002\rq\u0012xn\u001c;?\u0013\tYu'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&8\u0003%Ign\u001d;b]\u000e,\u0007%\u0001\u0003d_:4\u0007C\u0001*T\u001b\u0005q\u0013B\u0001+/\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0004/fS\u0006C\u0001-\u0001\u001b\u0005a\u0003\"B!\u0005\u0001\u0004!\u0005\"\u0002)\u0005\u0001\u0004\t\u0016!D7fiJL7m]\"p]\u001aLw\r\u0005\u0002Y;&\u0011a\f\f\u0002\u000e\u001b\u0016$(/[2t\u0007>tg-[4\u0002\u000bMLgn[:\u0016\u0003\u0005\u00042AY4j\u001b\u0005\u0019'B\u00013f\u0003\u001diW\u000f^1cY\u0016T!AZ\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002iG\nY\u0011I\u001d:bs\n+hMZ3s!\tQW.D\u0001l\u0015\taG&\u0001\u0003tS:\\\u0017B\u00018l\u0005\u0011\u0019\u0016N\\6\u0002\rMLgn[:!\u0003\u001d\u0019x.\u001e:dKN,\u0012A\u001d\t\u0004E\u001e\u001c\bC\u0001;x\u001b\u0005)(B\u0001<-\u0003\u0019\u0019x.\u001e:dK&\u0011\u00010\u001e\u0002\u0007'>,(oY3\u0002\u0011M|WO]2fg\u0002\n\u0001B]3hSN$(/_\u000b\u0002yB\u0019Q0a\u0002\u000e\u0003yT!!L@\u000b\t\u0005\u0005\u00111A\u0001\tG>$\u0017\r[1mK*\u0011\u0011QA\u0001\u0004G>l\u0017bAA\u0005}\nqQ*\u001a;sS\u000e\u0014VmZ5tiJL\u0018!\u0003:fO&\u001cHO]=!\u0003\u001d\u0011XO\u001c8j]\u001e,\"!!\u0005\u0011\u0007Y\n\u0019\"C\u0002\u0002\u0016]\u0012qAQ8pY\u0016\fg.A\u0006sk:t\u0017N\\4`I\u0015\fH\u0003BA\u000e\u0003C\u00012ANA\u000f\u0013\r\tyb\u000e\u0002\u0005+:LG\u000fC\u0005\u0002$5\t\t\u00111\u0001\u0002\u0012\u0005\u0019\u0001\u0010J\u0019\u0002\u0011I,hN\\5oO\u0002\na\"\\3ue&\u001c7oU3sm2,G/\u0006\u0002\u0002,A)a'!\f\u00022%\u0019\u0011qF\u001c\u0003\r=\u0003H/[8o!\rQ\u00171G\u0005\u0004\u0003kY'AD'fiJL7m]*feZdW\r^\u0001\u0013[\u0016$(/[2t'\u0016\u0014h\u000f\\3u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005m\u0002\"CA\u0012!\u0005\u0005\t\u0019AA\u0016\u0003=iW\r\u001e:jGN\u001cVM\u001d<mKR\u0004\u0013!\u00059s_6,G\u000f[3vgN+'O\u001e7fiV\u0011\u00111\t\t\u0006m\u00055\u0012Q\t\t\u0004U\u0006\u001d\u0013bAA%W\n\t\u0002K]8nKRDW-^:TKJ4H.\u001a;\u0002+A\u0014x.\\3uQ\u0016,8oU3sm2,Go\u0018\u0013fcR!\u00111DA(\u0011%\t\u0019cEA\u0001\u0002\u0004\t\u0019%\u0001\nqe>lW\r\u001e5fkN\u001cVM\u001d<mKR\u0004\u0013AE4fiN+'O\u001e7fi\"\u000bg\u000e\u001a7feN,\"!a\u0016\u0011\u000bY\nI&!\u0018\n\u0007\u0005msGA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002`\u00055TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u000fM,'O\u001e7fi*!\u0011qMA5\u0003\u0015QW\r\u001e;z\u0015\r\tYGM\u0001\bK\u000ed\u0017\u000e]:f\u0013\u0011\ty'!\u0019\u0003+M+'O\u001e7fi\u000e{g\u000e^3yi\"\u000bg\u000e\u001a7fe\u0006)1\u000f^1siR!\u00111DA;\u0011%\t9H\u0006I\u0001\u0002\u0004\t\t\"A\u000bsK\u001eL7\u000f^3s'R\fG/[2T_V\u00148-Z:\u0002\u001fM$\u0018M\u001d;%I\u00164\u0017-\u001e7uIE*\"!! +\t\u0005E\u0011qP\u0016\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005v]\u000eDWmY6fI*\u0019\u00111R\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!1\u000f^8q)\t\tY\"\u0001\u0004sKB|'\u000f^\u0001\u0012EVLG\u000e\u001a*fO&\u001cHO]=OC6,Gc\u0001#\u0002\u001c\")aO\u0007a\u0001g\u0006\u0001r-\u001a;T_V\u00148-Z:Cs:\u000bW.\u001a\u000b\u0005\u0003C\u000b\u0019\fE\u0003\u0002$\u000656O\u0004\u0003\u0002&\u0006%fbA$\u0002(&\t\u0001(C\u0002\u0002,^\nq\u0001]1dW\u0006<W-\u0003\u0003\u00020\u0006E&aA*fc*\u0019\u00111V\u001c\t\r\u0005U6\u00041\u0001E\u0003)\u0019x.\u001e:dK:\u000bW.Z\u0001\u000fe\u0016<\u0017n\u001d;feN{WO]2f)\u0011\tY\"a/\t\u000bYd\u0002\u0019A:\u0002\u0019I,Wn\u001c<f'>,(oY3\u0015\t\u0005m\u0011\u0011\u0019\u0005\u0006mv\u0001\ra]\u0001\u0010e\u0016<\u0017n\u001d;feN{WO]2fg\u0006i!/Z4jgR,'oU5oWN\fQ\"T3ue&\u001c7oU=ti\u0016l\u0007C\u0001-\"'\t\tS\u0007\u0006\u0002\u0002J\u0006Q1+\u0013(L?J+u)\u0012-\u0016\u0005\u0005M\u0007\u0003BAk\u0003?l!!a6\u000b\t\u0005e\u00171\\\u0001\t[\u0006$8\r[5oO*\u0019\u0011Q\\\u001c\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\f9NA\u0003SK\u001e,\u00070A\u0006T\u0013:[uLU#H\u000bb\u0003\u0013\u0001D*P+J\u001bUi\u0018*F\u000f\u0016C\u0016!D*P+J\u001bUi\u0018*F\u000f\u0016C\u0006%A\tN\u0013:KU*\u0011'`!>cEjX+O\u0013R\u0003B!!<\u0002z6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u00190\u0001\u0006d_:\u001cWO\u001d:f]RTA!!8\u0002v*\u0011\u0011q_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002|\u0006=(\u0001\u0003+j[\u0016,f.\u001b;\u0002'5Ke*S'B\u0019~\u0003v\n\u0014'`!\u0016\u0013\u0016j\u0014#\u0011\u0007Y\u0012\t!C\u0002\u0003\u0004]\u00121!\u00138u\u0003e\u0019\u0007.Z2l\u001b&t\u0017.\\1m!>dG.\u001b8h!\u0016\u0014\u0018n\u001c3\u0015\r\u0005m!\u0011\u0002B\u0007\u0011\u001d\u0011Y!\u000ba\u0001\u0003W\f\u0001\u0002]8mYVs\u0017\u000e\u001e\u0005\b\u0005\u001fI\u0003\u0019AA\u0000\u0003)\u0001x\u000e\u001c7QKJLw\u000eZ\u0001\u0014GJ,\u0017\r^3NKR\u0014\u0018nY:TsN$X-\u001c\u000b\u0006/\nU!q\u0003\u0005\u0006\u0003*\u0002\r\u0001\u0012\u0005\u0006!*\u0002\r!\u0015")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final SparkConf conf;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry registry;
    private boolean running;
    private Option<MetricsServlet> metricsServlet;
    private Option<PrometheusServlet> prometheusServlet;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MetricsSystem createMetricsSystem(String string, SparkConf sparkConf) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, sparkConf);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String instance() {
        return this.instance;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private Option<MetricsServlet> metricsServlet() {
        return this.metricsServlet;
    }

    private void metricsServlet_$eq(Option<MetricsServlet> x$1) {
        this.metricsServlet = x$1;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    public ServletContextHandler[] getServletHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (ServletContextHandler[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metricsServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServletContextHandler.class)));
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            StaticSources$.MODULE$.allSources().foreach((Function1 & Serializable & scala.Serializable)source -> {
                this.registerSource(source);
                return BoxedUnit.UNIT;
            });
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.stop();
                return BoxedUnit.UNIT;
            });
            this.registry().removeMatching((x$5, x$6) -> true);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.report();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildRegistryName(Source source) {
        String string;
        String defaultName;
        block7: {
            Option executorId;
            Option metricsNamespace;
            block6: {
                metricsNamespace = ((Option)this.conf.get(package$.MODULE$.METRICS_NAMESPACE())).orElse((Function0 & Serializable & scala.Serializable)() -> $this.conf.getOption("spark.app.id"));
                executorId = (Option)this.conf.get(package$.MODULE$.EXECUTOR_ID());
                defaultName = MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
                String string2 = this.instance();
                String string3 = "driver";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block6;
                String string4 = this.instance();
                String string5 = "executor";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
            }
            if (metricsNamespace.isDefined() && executorId.isDefined()) {
                string = MetricRegistry.name((String)((String)metricsNamespace.get()), (String[])new String[]{(String)executorId.get(), source.sourceName()});
                return string;
            }
            if (metricsNamespace.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Using default name ").append(defaultName).append(" for source because neither ").append(package$.MODULE$.METRICS_NAMESPACE().key()).append(" nor spark.app.id is set.").toString());
            }
            if (executorId.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Using default name ").append(defaultName).append(" for source because spark.executor.id is ").append("not set.").toString());
            }
            string = defaultName;
            return string;
        }
        string = defaultName;
        return string;
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        Seq seq;
        ArrayBuffer<Source> arrayBuffer = this.sources();
        synchronized (arrayBuffer) {
            seq = ((SeqLike)this.sources().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$8)))).toSeq();
        }
        return seq;
    }

    public void registerSource(Source source) {
        ArrayBuffer<Source> arrayBuffer = this.sources();
        synchronized (arrayBuffer) {
            this.sources().$plus$eq((Object)source);
        }
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        ArrayBuffer<Source> arrayBuffer = this.sources();
        synchronized (arrayBuffer) {
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.sources().$minus$eq((Object)source);
        }
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching((name, x$9) -> name.startsWith(regName));
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            BoxedUnit boxedUnit;
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                try {
                    Sink sink;
                    Object object = kv._1();
                    String string = "servlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        MetricsServlet servlet = (MetricsServlet)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                        this.metricsServlet_$eq((Option<MetricsServlet>)new Some((Object)servlet));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object object2 = kv._1();
                    String string2 = "prometheusServlet";
                    if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                        PrometheusServlet servlet = (PrometheusServlet)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                        this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)servlet));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    try {
                        sink = (Sink)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        sink = (Sink)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.registry(), null);
                    }
                    Sink sink2 = sink;
                    boxedUnit = this.sinks().$plus$eq((Object)sink2);
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$8) {
        String string = x$8.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Source source = (Source)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
            $this.registerSource(source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, SparkConf conf) {
        this.instance = instance;
        this.conf = conf;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.registry = new MetricRegistry();
        this.running = false;
        this.metricsServlet = None$.MODULE$;
        this.prometheusServlet = None$.MODULE$;
        this.metricsConfig.initialize();
    }
}

