/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.EventLogFileWriter;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter;
import org.apache.spark.deploy.history.SingleEventLogFileWriter;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class EventLogFileWriter$ {
    public static EventLogFileWriter$ MODULE$;
    private final String IN_PROGRESS;
    private final String COMPACTED;
    private final FsPermission LOG_FILE_PERMISSIONS;
    private final FsPermission LOG_FOLDER_PERMISSIONS;

    static {
        new EventLogFileWriter$();
    }

    public String IN_PROGRESS() {
        return this.IN_PROGRESS;
    }

    public String COMPACTED() {
        return this.COMPACTED;
    }

    public FsPermission LOG_FILE_PERMISSIONS() {
        return this.LOG_FILE_PERMISSIONS;
    }

    public FsPermission LOG_FOLDER_PERMISSIONS() {
        return this.LOG_FOLDER_PERMISSIONS;
    }

    public EventLogFileWriter apply(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf, Configuration hadoopConf) {
        return BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.EVENT_LOG_ENABLE_ROLLING())) ? new RollingEventLogFilesWriter(appId, appAttemptId, logBaseDir, sparkConf, hadoopConf) : new SingleEventLogFileWriter(appId, appAttemptId, logBaseDir, sparkConf, hadoopConf);
    }

    /*
     * WARNING - void declaration
     */
    public String nameForAppAndAttempt(String appId, Option<String> appAttemptId) {
        void var3_3;
        String base = Utils$.MODULE$.sanitizeDirName(appId);
        return appAttemptId.isDefined() ? new StringBuilder(1).append(base).append("_").append(Utils$.MODULE$.sanitizeDirName((String)appAttemptId.get())).toString() : var3_3;
    }

    public Option<String> codecName(Path log) {
        String logName = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(log.getName())).stripSuffix(this.COMPACTED()))).stripSuffix(this.IN_PROGRESS());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logName.split("\\."))).tail())).lastOption();
    }

    public boolean isCompacted(Path log) {
        return log.getName().endsWith(this.COMPACTED());
    }

    private EventLogFileWriter$() {
        MODULE$ = this;
        this.IN_PROGRESS = ".inprogress";
        this.COMPACTED = ".compact";
        this.LOG_FILE_PERMISSIONS = new FsPermission((short)Integer.parseInt("660", 8));
        this.LOG_FOLDER_PERMISSIONS = new FsPermission((short)Integer.parseInt("770", 8));
    }
}

