/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.api.python.PythonWorkerFactory$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.security.SocketAuthHelper;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.WeakHashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t\u001da!B\u001a5\u0001ar\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011a\u0003!\u0011!Q\u0001\neCQ\u0001\u0018\u0001\u0005\u0002uCqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004h\u0001\u0001\u0006I\u0001\u001a\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019Q\u0007\u0001)A\u0005\u001b\"91\u000e\u0001b\u0001\n\u0013I\u0007B\u00027\u0001A\u0003%Q\nC\u0004n\u0001\t\u0007I\u0011\u00028\t\rU\u0004\u0001\u0015!\u0003p\u0011\u001d1\b\u00011A\u0005\n]D\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\t\u000f\u0005=\u0001\u0001)Q\u0005q\"I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00022!I\u0011q\b\u0001A\u0002\u0013%\u0011\u0011\t\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017B\u0001\"a\u0014\u0001A\u0003&\u00111\t\u0005\n\u0003'\u0002!\u0019!C\u0005\u0003+B\u0001\"!\u001c\u0001A\u0003%\u0011q\u000b\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a\u001f\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003\u007f\u0002\u0001\u0019!C\u0005\u0003\u0003C\u0011\"!#\u0001\u0001\u0004%I!a#\t\u0011\u0005=\u0005\u0001)Q\u0005\u0003\u0007C\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005e\u0005\u0001)A\u0005\u0003/C\u0001\"!(\u0001\u0005\u0004%I!\u001b\u0005\b\u0003?\u0003\u0001\u0015!\u0003N\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!!-\u0001\t\u0013\t\u0019\u000bC\u0004\u00024\u0002!I!a)\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u0011\u0011\u0018\u0001\u0005\n\u0005mfABAi\u0001\u0011\t\u0019\u000e\u0003\u0004]I\u0011\u0005\u00111\u001c\u0005\b\u0003C$C\u0011IA\\\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003oCq!!:\u0001\t\u0013\t9\fC\u0004\u0002h\u0002!\t!a.\t\u000f\u0005%\b\u0001\"\u0001\u0002l\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005MxaBA|i!%\u0011\u0011 \u0004\u0007gQBI!a?\t\rqkC\u0011AA\u007f\u0011%\ty0\fb\u0001\n\u0003\t\t\u0005\u0003\u0005\u0003\u00025\u0002\u000b\u0011BA\"\u0011%\u0011\u0019!\fb\u0001\n\u0003\t\t\t\u0003\u0005\u0003\u00065\u0002\u000b\u0011BAB\u0005M\u0001\u0016\u0010\u001e5p]^{'o[3s\r\u0006\u001cGo\u001c:z\u0015\t)d'\u0001\u0004qsRDwN\u001c\u0006\u0003oa\n1!\u00199j\u0015\tI$(A\u0003ta\u0006\u00148N\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<7c\u0001\u0001@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n1\u0011I\\=SK\u001a\u0004\"AR%\u000e\u0003\u001dS!\u0001\u0013\u001d\u0002\u0011%tG/\u001a:oC2L!AS$\u0003\u000f1{wmZ5oO\u0006Q\u0001/\u001f;i_:,\u00050Z2\u0004\u0001A\u0011a*\u0016\b\u0003\u001fN\u0003\"\u0001U!\u000e\u0003ES!A\u0015'\u0002\rq\u0012xn\u001c;?\u0013\t!\u0016)\u0001\u0004Qe\u0016$WMZ\u0005\u0003-^\u0013aa\u0015;sS:<'B\u0001+B\u0003\u001d)gN\u001e,beN\u0004BA\u0014.N\u001b&\u00111l\u0016\u0002\u0004\u001b\u0006\u0004\u0018A\u0002\u001fj]&$h\bF\u0002_A\u0006\u0004\"a\u0018\u0001\u000e\u0003QBQaS\u0002A\u00025CQ\u0001W\u0002A\u0002e\u000b\u0011\"^:f\t\u0006,Wn\u001c8\u0016\u0003\u0011\u0004\"\u0001Q3\n\u0005\u0019\f%a\u0002\"p_2,\u0017M\\\u0001\u000bkN,G)Y3n_:\u0004\u0013\u0001\u00043bK6|g.T8ek2,W#A'\u0002\u001b\u0011\fW-\\8o\u001b>$W\u000f\\3!\u000319xN]6fe6{G-\u001e7f\u000359xN]6fe6{G-\u001e7fA\u0005Q\u0011-\u001e;i\u0011\u0016d\u0007/\u001a:\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u001d\u0002\u0011M,7-\u001e:jifL!\u0001^9\u0003!M{7m[3u\u0003V$\b\u000eS3ma\u0016\u0014\u0018aC1vi\"DU\r\u001c9fe\u0002\na\u0001Z1f[>tW#\u0001=\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018\u0001\u00027b]\u001eT\u0011!`\u0001\u0005U\u00064\u0018-\u0003\u0002\u0000u\n9\u0001K]8dKN\u001c\u0018A\u00033bK6|gn\u0018\u0013fcR!\u0011QAA\u0006!\r\u0001\u0015qA\u0005\u0004\u0003\u0013\t%\u0001B+oSRD\u0001\"!\u0004\u000e\u0003\u0003\u0005\r\u0001_\u0001\u0004q\u0012\n\u0014a\u00023bK6|g\u000e\t\u0015\b\u001d\u0005M\u0011qEA\u0015!\u0011\t)\"a\t\u000e\u0005\u0005]!\u0002BA\r\u00037\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\ti\"a\b\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002\"\u0005)!.\u0019<bq&!\u0011QEA\f\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002,\u0005!1/\u001a7g\u0003)!\u0017-Z7p]\"{7\u000f^\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oa\u0018a\u00018fi&!\u00111HA\u001b\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\u0002\u0017\u0011\fW-\\8o\u0011>\u001cH\u000fI\u0001\u000bI\u0006,Wn\u001c8Q_J$XCAA\"!\r\u0001\u0015QI\u0005\u0004\u0003\u000f\n%aA%oi\u0006qA-Y3n_:\u0004vN\u001d;`I\u0015\fH\u0003BA\u0003\u0003\u001bB\u0011\"!\u0004\u0013\u0003\u0003\u0005\r!a\u0011\u0002\u0017\u0011\fW-\\8o!>\u0014H\u000f\t\u0015\b'\u0005M\u0011qEA\u0015\u00035!\u0017-Z7p]^{'o[3sgV\u0011\u0011q\u000b\t\t\u00033\n\u0019'a\u001a\u0002D5\u0011\u00111\f\u0006\u0005\u0003;\ny&A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0005\u0014)\u0001\u0006d_2dWm\u0019;j_:LA!!\u001a\u0002\\\tYq+Z1l\u0011\u0006\u001c\b.T1q!\u0011\t\u0019$!\u001b\n\t\u0005-\u0014Q\u0007\u0002\u0007'>\u001c7.\u001a;\u0002\u001d\u0011\fW-\\8o/>\u00148.\u001a:tA!:Q#a\u0005\u0002(\u0005%\u0012aC5eY\u0016<vN]6feN,\"!!\u001e\u0011\r\u0005e\u0013qOA4\u0013\u0011\tI(a\u0017\u0003\u000bE+X-^3\u0002\u0019%$G.Z,pe.,'o\u001d\u0011)\u000f]\t\u0019\"a\n\u0002*\u0005qA.Y:u\u0003\u000e$\u0018N^5us:\u001bXCAAB!\r\u0001\u0015QQ\u0005\u0004\u0003\u000f\u000b%\u0001\u0002'p]\u001e\f!\u0003\\1ti\u0006\u001bG/\u001b<jift5o\u0018\u0013fcR!\u0011QAAG\u0011%\ti!GA\u0001\u0002\u0004\t\u0019)A\bmCN$\u0018i\u0019;jm&$\u0018PT:!Q\u001dQ\u00121CA\u0014\u0003S\tQb]5na2,wk\u001c:lKJ\u001cXCAAL!\u001d\tI&a\u0019\u0002ha\fab]5na2,wk\u001c:lKJ\u001c\b\u0005K\u0004\u001d\u0003'\t9#!\u000b\u0002\u0015ALH\u000f[8o!\u0006$\b.A\u0006qsRDwN\u001c)bi\"\u0004\u0013AB2sK\u0006$X\r\u0006\u0002\u0002&B9\u0001)a*\u0002h\u0005-\u0016bAAU\u0003\n1A+\u001e9mKJ\u0002R\u0001QAW\u0003\u0007J1!a,B\u0005\u0019y\u0005\u000f^5p]\u0006\u00192M]3bi\u0016$\u0006N]8vO\"$\u0015-Z7p]\u0006\u00112M]3bi\u0016\u001c\u0016.\u001c9mK^{'o[3s\u0003-\u0019H/\u0019:u\t\u0006,Wn\u001c8\u0015\u0005\u0005\u0015\u0011a\u0006:fI&\u0014Xm\u0019;TiJ,\u0017-\\:U_N#H-\u001a:s)\u0019\t)!!0\u0002N\"9\u0011qX\u0012A\u0002\u0005\u0005\u0017AB:uI>,H\u000f\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9\r`\u0001\u0003S>LA!a3\u0002F\nY\u0011J\u001c9viN#(/Z1n\u0011\u001d\tym\ta\u0001\u0003\u0003\faa\u001d;eKJ\u0014(!D'p]&$xN\u001d+ie\u0016\fGmE\u0002%\u0003+\u00042!_Al\u0013\r\tIN\u001f\u0002\u0007)\"\u0014X-\u00193\u0015\u0005\u0005u\u0007cAApI5\t\u0001!A\u0002sk:\f!c\u00197fC:,\b/\u00133mK^{'o[3sg\u0006Q1\u000f^8q\t\u0006,Wn\u001c8\u0002\tM$x\u000e]\u0001\u000bgR|\u0007oV8sW\u0016\u0014H\u0003BA\u0003\u0003[Dq!a<+\u0001\u0004\t9'\u0001\u0004x_J\\WM]\u0001\u000ee\u0016dW-Y:f/>\u00148.\u001a:\u0015\t\u0005\u0015\u0011Q\u001f\u0005\b\u0003_\\\u0003\u0019AA4\u0003M\u0001\u0016\u0010\u001e5p]^{'o[3s\r\u0006\u001cGo\u001c:z!\tyVf\u0005\u0002.\u007fQ\u0011\u0011\u0011`\u0001\u0018!J{5)R*T?^\u000b\u0015\nV0U\u00136+u*\u0016+`\u001bN\u000b\u0001\u0004\u0015*P\u0007\u0016\u001b6kX,B\u0013R{F+S'F\u001fV#v,T*!\u0003YIE\tT#`/>\u00136*\u0012*`)&kUiT+U?:\u001b\u0016aF%E\u0019\u0016{vk\u0014*L\u000bJ{F+S'F\u001fV#vLT*!\u0001")
public class PythonWorkerFactory
implements Logging {
    public final String org$apache$spark$api$python$PythonWorkerFactory$$pythonExec;
    private final scala.collection.immutable.Map<String, String> envVars;
    private final boolean useDaemon;
    private final String daemonModule;
    private final String workerModule;
    private final SocketAuthHelper authHelper;
    @GuardedBy(value="self")
    private Process daemon;
    private final InetAddress daemonHost;
    @GuardedBy(value="self")
    private int daemonPort;
    @GuardedBy(value="self")
    private final WeakHashMap<Socket, Object> daemonWorkers;
    @GuardedBy(value="self")
    private final Queue<Socket> idleWorkers;
    @GuardedBy(value="self")
    private long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    @GuardedBy(value="self")
    private final WeakHashMap<Socket, Process> simpleWorkers;
    private final String pythonPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long IDLE_WORKER_TIMEOUT_NS() {
        return PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS();
    }

    public static int PROCESS_WAIT_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean useDaemon() {
        return this.useDaemon;
    }

    private String daemonModule() {
        return this.daemonModule;
    }

    private String workerModule() {
        return this.workerModule;
    }

    private SocketAuthHelper authHelper() {
        return this.authHelper;
    }

    private Process daemon() {
        return this.daemon;
    }

    private void daemon_$eq(Process x$1) {
        this.daemon = x$1;
    }

    public InetAddress daemonHost() {
        return this.daemonHost;
    }

    private int daemonPort() {
        return this.daemonPort;
    }

    private void daemonPort_$eq(int x$1) {
        this.daemonPort = x$1;
    }

    private WeakHashMap<Socket, Object> daemonWorkers() {
        return this.daemonWorkers;
    }

    private Queue<Socket> idleWorkers() {
        return this.idleWorkers;
    }

    public long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs() {
        return this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(long x$1) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = x$1;
    }

    private WeakHashMap<Socket, Process> simpleWorkers() {
        return this.simpleWorkers;
    }

    private String pythonPath() {
        return this.pythonPath;
    }

    public Tuple2<Socket, Option<Object>> create() {
        Tuple2<Socket, Option<Object>> tuple2;
        if (this.useDaemon()) {
            block7: {
                PythonWorkerFactory pythonWorkerFactory = this;
                synchronized (pythonWorkerFactory) {
                    Tuple2 tuple22;
                    block6: {
                        if (this.idleWorkers().nonEmpty()) {
                            Socket worker = (Socket)this.idleWorkers().dequeue();
                            tuple22 = new Tuple2((Object)worker, (Object)this.daemonWorkers().get((Object)worker));
                            break block6;
                        }
                        break block7;
                    }
                    return tuple22;
                }
            }
            tuple2 = this.createThroughDaemon();
        } else {
            tuple2 = this.createSimpleWorker();
        }
        return tuple2;
    }

    private Tuple2<Socket, Option<Object>> createThroughDaemon() {
        Tuple2 tuple2;
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            this.startDaemon();
            tuple2 = this.liftedTree1$1();
        }
        return tuple2;
    }

    private Tuple2<Socket, Option<Object>> createSimpleWorker() {
        Tuple2 tuple2;
        try (ServerSocket serverSocket = null;){
            serverSocket = new ServerSocket(0, 1, InetAddress.getByAddress((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), ClassTag$.MODULE$.Byte())));
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.workerModule()}));
            java.util.Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            workerEnv.put("PYTHON_WORKER_FACTORY_PORT", Integer.toString(serverSocket.getLocalPort()));
            workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            Process worker = pb.start();
            this.redirectStreamsToStderr(worker.getInputStream(), worker.getErrorStream());
            serverSocket.setSoTimeout(10000);
            try {
                Socket socket = serverSocket.accept();
                this.authHelper().authClient(socket);
                int pid = new DataInputStream(socket.getInputStream()).readInt();
                if (pid < 0) {
                    throw new IllegalStateException(new StringBuilder(41).append("Python failed to launch worker with code ").append(pid).toString());
                }
                PythonWorkerFactory pythonWorkerFactory = this;
                synchronized (pythonWorkerFactory) {
                    this.simpleWorkers().put((Object)socket, (Object)worker);
                }
                tuple2 = new Tuple2((Object)socket, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)pid)));
            }
            catch (Exception e) {
                throw new SparkException("Python worker failed to connect back.", e);
            }
        }
        return tuple2;
    }

    private synchronized void startDaemon() {
        if (this.daemon() != null) {
            return;
        }
        try {
            List<Object> command = Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.daemonModule()});
            ProcessBuilder pb = new ProcessBuilder(command);
            java.util.Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            this.daemon_$eq(pb.start());
            DataInputStream in = new DataInputStream(this.daemon().getInputStream());
            try {
                this.daemonPort_$eq(in.readInt());
            }
            catch (EOFException eOFException) {
                if (this.daemon().isAlive()) {
                    throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule(), SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError$default$2());
                }
                throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.daemon().exitValue())));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            if (this.daemonPort() < 1 || this.daemonPort() > 65535) {
                String arg$macro$1 = this.daemonModule();
                Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)this.daemonPort());
                int arg$macro$3 = this.daemonPort();
                String arg$macro$4 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(command).asScala()).mkString(" ");
                String arg$macro$5 = this.pythonPath();
                String exceptionMessage = new StringOps("\n            |Bad data in %s's standard output. Invalid port number:\n            |  %s (0x%08x)\n            |Python command to execute the daemon was:\n            |  %s\n            |Check that you don't have any unexpected modules or libraries in\n            |your PYTHONPATH:\n            |  %s\n            |Also, check if you have a sitecustomize.py module in your python path,\n            |or in your python installation, that is printing to standard output").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToInteger((int)arg$macro$3), arg$macro$4, arg$macro$5}));
                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(exceptionMessage)).stripMargin());
            }
            this.redirectStreamsToStderr(in, this.daemon().getErrorStream());
        }
        catch (Exception e) {
            String stderr = (String)Option$.MODULE$.apply((Object)this.daemon()).flatMap((Function1 & Serializable & scala.Serializable)d -> Utils$.MODULE$.getStderr((Process)d, PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            this.stopDaemon();
            String string = stderr;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String formattedStderr = stderr.replace("\n", "\n  ");
                String errorMessage = new StringBuilder(124).append("\n              |Error from python worker:\n              |  ").append(formattedStderr).append("\n              |PYTHONPATH was:\n              |  ").append(this.pythonPath()).append("\n              |").append(e).toString();
                SparkException wrappedException = new SparkException(new StringOps(Predef$.MODULE$.augmentString(errorMessage)).stripMargin());
                wrappedException.setStackTrace(e.getStackTrace());
                throw wrappedException;
            }
            throw e;
        }
    }

    private void redirectStreamsToStderr(InputStream stdout, InputStream stderr) {
        try {
            new RedirectThread(stdout, System.err, new StringBuilder(18).append("stdout reader for ").append(this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString(), RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            new RedirectThread(stderr, System.err, new StringBuilder(18).append("stderr reader for ").append(this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString(), RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception in redirecting streams", e);
        }
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers() {
        while (this.idleWorkers().nonEmpty()) {
            Socket worker = (Socket)this.idleWorkers().dequeue();
            try {
                worker.close();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close worker socket", e);
            }
        }
    }

    private void stopDaemon() {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            Map map;
            if (this.useDaemon()) {
                this.org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                if (this.daemon() != null) {
                    this.daemon().destroy();
                }
                this.daemon_$eq(null);
                this.daemonPort_$eq(0);
                map = BoxedUnit.UNIT;
            } else {
                map = this.simpleWorkers().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public void stop() {
        this.stopDaemon();
    }

    public void stopWorker(Socket worker) {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            if (this.useDaemon()) {
                if (this.daemon() != null) {
                    this.daemonWorkers().get((Object)worker).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> {
                        DataOutputStream output = new DataOutputStream(this.daemon().getOutputStream());
                        output.writeInt(pid);
                        output.flush();
                        this.daemon().getOutputStream().flush();
                    });
                }
            } else {
                this.simpleWorkers().get((Object)worker).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
        worker.close();
    }

    public void releaseWorker(Socket worker) {
        if (this.useDaemon()) {
            PythonWorkerFactory pythonWorkerFactory = this;
            synchronized (pythonWorkerFactory) {
                this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                this.idleWorkers().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Socket[]{worker}));
            }
        } else {
            try {
                worker.close();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close worker socket", e);
            }
        }
    }

    private final Tuple2 createSocket$1() {
        Socket socket = new Socket(this.daemonHost(), this.daemonPort());
        int pid = new DataInputStream(socket.getInputStream()).readInt();
        if (pid < 0) {
            throw new IllegalStateException(new StringBuilder(48).append("Python daemon failed to launch worker with code ").append(pid).toString());
        }
        this.authHelper().authToServer(socket);
        this.daemonWorkers().put((Object)socket, (Object)BoxesRunTime.boxToInteger((int)pid));
        return new Tuple2((Object)socket, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)pid)));
    }

    private final /* synthetic */ Tuple2 liftedTree1$1() {
        Tuple2 tuple2;
        try {
            tuple2 = this.createSocket$1();
        }
        catch (SocketException exc) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to open socket to Python daemon:", exc);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Assuming that daemon unexpectedly quit, attempting to restart");
            this.stopDaemon();
            this.startDaemon();
            tuple2 = this.createSocket$1();
        }
        return tuple2;
    }

    public PythonWorkerFactory(String pythonExec, scala.collection.immutable.Map<String, String> envVars) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec = pythonExec;
        this.envVars = envVars;
        Logging.$init$(this);
        boolean useDaemonEnabled = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(Python$.MODULE$.PYTHON_USE_DAEMON()));
        this.useDaemon = !System.getProperty("os.name").startsWith("Windows") && useDaemonEnabled;
        this.daemonModule = (String)((Option)SparkEnv$.MODULE$.get().conf().get(Python$.MODULE$.PYTHON_DAEMON_MODULE())).map((Function1 & Serializable & scala.Serializable)value -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(186).append("Python daemon module in PySpark is set to [").append((String)value).append("] in '").append(Python$.MODULE$.PYTHON_DAEMON_MODULE().key()).append("', ").append("using this to start the daemon up. Note that this configuration only has an effect when ").append("'").append(Python$.MODULE$.PYTHON_USE_DAEMON().key()).append("' is enabled and the platform is not Windows.").toString());
            return value;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "pyspark.daemon");
        this.workerModule = (String)((Option)SparkEnv$.MODULE$.get().conf().get(Python$.MODULE$.PYTHON_WORKER_MODULE())).map((Function1 & Serializable & scala.Serializable)value -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(182).append("Python worker module in PySpark is set to [").append((String)value).append("] in '").append(Python$.MODULE$.PYTHON_WORKER_MODULE().key()).append("', ").append("using this to start the worker up. Note that this configuration only has an effect when ").append("'").append(Python$.MODULE$.PYTHON_USE_DAEMON().key()).append("' is disabled or the platform is Windows.").toString());
            return value;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "pyspark.worker");
        this.authHelper = new SocketAuthHelper(SparkEnv$.MODULE$.get().conf());
        this.daemon = null;
        this.daemonHost = InetAddress.getByAddress((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, 0, 0, 1}), ClassTag$.MODULE$.Byte()));
        this.daemonPort = 0;
        this.daemonWorkers = new WeakHashMap();
        this.idleWorkers = new Queue();
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = 0L;
        new MonitorThread().start();
        this.simpleWorkers = new WeakHashMap();
        this.pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{PythonUtils$.MODULE$.sparkPythonPath(), (String)envVars.getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> ""), (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> "")}));
    }

    private class MonitorThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                PythonWorkerFactory pythonWorkerFactory = this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer();
                synchronized (pythonWorkerFactory) {
                    if (PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS() < System.nanoTime() - this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs()) {
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                    }
                }
                Thread.sleep(10000L);
            }
        }

        public /* synthetic */ PythonWorkerFactory org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer() {
            return PythonWorkerFactory.this;
        }

        public MonitorThread() {
            if (PythonWorkerFactory.this == null) {
                throw null;
            }
            super(new StringBuilder(24).append("Idle Worker Monitor for ").append(PythonWorkerFactory.this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec).toString());
            this.setDaemon(true);
        }
    }
}

