/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;

public class NPDataAnalyzer {
    static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String DT_AFPDS = "*AFPDS";
    private static final String DT_USERASCII = "*USERASCII";
    private static final String DT_SCS = "*SCS";
    static final byte ASCII_TRNSPRNT_CC = 3;
    static final byte BACKSPACE_CC = 22;
    static final byte UNITBACKSPACE_CC = 26;
    static final byte BEL_CC = 47;
    static final byte CARRIAGE_RETURN_CC = 13;
    static final byte ENABLE_PRESENTATION_CC = 20;
    static final byte EXPANDED_BACKSPACE_CC = 54;
    static final byte FORM_FEED_CC = 12;
    static final byte GRAPHIC_ESCAPE_CC = 8;
    static final byte HORIZONTAL_TAB_CC = 5;
    static final byte INDENT_TAB_CC = 57;
    static final byte INDEX_RETURN_CC = 51;
    static final byte INHIBIT_PRESENTATION_CC = 36;
    static final byte INTERCHANGE_RECORD_SEPARATOR_CC = 30;
    static final byte LINE_FEED_CC = 37;
    static final byte NEW_LINE_CC = 21;
    static final byte NULL_CC = 0;
    static final byte PRESENTATION_POSITION_CC = 52;
    static final byte REQUIRED_FORM_FEED_CC = 58;
    static final byte REQUIRED_NEW_LINE_CC = 6;
    static final byte SPACE_CC = 64;
    static final byte REQUIRED_SPACE_CC = 65;
    static final byte SET_ATTRIBUTE_CC = 40;
    static final byte SHIFT_OUT_CC = 14;
    static final byte SHIFT_IN_CC = 15;
    static final byte SWITCH_CC = 42;
    static final byte CSP_CC = 43;
    static final byte SUBSTITUTE_CC = 63;
    static final byte GRAPHIC_ERROR_ACTION_CC = -56;
    static final byte HORIZONTAL_FORMAT_CC = -63;
    static final byte LINE_DENSITY_CC = -58;
    static final byte NUMERIC_SPACE_CC = -31;
    static final byte SUBSCRIPT_CC = 56;
    static final byte SUPERSCRIPT_CC = 9;
    static final byte SYLLABLE_HYPHEN_CC = -54;
    static final byte TRANSPARENT_CC = 53;
    static final byte VERTICAL_CHANNEL_SELECT_CC = 4;
    static final byte VERTICAL_TAB_CC = 11;
    static final byte WORD_UNDERSCORE_CC = 35;
    static final byte FONTCLASS = -47;
    static final byte SCG_CC = 1;
    static final byte SCGL_CC = -127;
    static final byte SFG_CC = 5;
    static final byte BES_CC = -118;
    static final byte EES_CC = -114;
    static final byte DOGTWO = -46;
    static final byte STAB_CC = 1;
    static final byte JUSTIFY_TEXTFIELD_CC = 3;
    static final byte SET_INDENTLV_CC = 7;
    static final byte SET_LINESPACE_CC = 9;
    static final byte RELEASE_LEFT_MARGIN_CC = 11;
    static final byte SET_JUSTIFYMODE_CC = 13;
    static final byte SET_HORZMARGINS_CC = 17;
    static final byte SET_LINEDISTANCE_CC = 21;
    static final byte PRINT_DENSITY_CC = 41;
    static final byte SET_PRESCOLOR_CC = 45;
    static final byte SET_PRESPAGESIZE_CC = 64;
    static final byte SET_INITCOND_CC = 69;
    static final byte SET_PPAGEMEDIA_CC = 72;
    static final byte SET_VERTMARGINS_CC = 73;
    static final byte SET_PRINTERSETUP_CC = 76;
    static final byte SET_ERROR_ACTION_CC = -123;
    static final byte VERTICAL_FORMAT_CC = -62;
    static final byte DOGTHREE = -45;
    static final byte STO_CC = -10;
    static final byte DOGFOUR = -44;
    static final byte BUS_CC = 10;
    static final byte EUS_CC = 14;
    static final byte BOS_CC = 114;
    static final byte EOS_CC = 118;
    static final byte FOXDOG = -3;
    static final byte DGL_CC = 0;
    static final byte SIT_CC = 1;
    static final byte SFSS_CC = 2;
    static final byte SPCC_CC = 3;
    static final byte PP_STRUCT_LEN = 3;
    static final byte PPCODE_AHPP = -64;
    static final byte PPCODE_AVPP = -60;
    static final byte PPCODE_RHPP = -56;
    static final byte PPCODE_RVPP = 76;
    static final byte SA_STRUCT_LEN = 3;
    static final byte ATTR_RESET = 0;
    static final byte ATTR_COLOR = 66;
    static final byte ATTR_HILITE = 65;
    static final byte ATTR_CHAR_SET = 67;

    private static boolean dataIsAFP(byte[] byArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n;
        while (n3 < n2 && !bl2) {
            if (byArray[n3] == 90) {
                if (n3 != n) {
                    bl = true;
                }
                if (n2 - n3 >= 3) {
                    int n4 = BinaryConverter.byteArrayToUnsignedShort(byArray, ++n3);
                    n3 += n4;
                    if (n4 >= 5) continue;
                    bl2 = true;
                    bl = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            bl = false;
            bl2 = true;
        }
        return bl;
    }

    private static boolean dataIsSCS(byte[] byArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        block36: while (n2 > 0 && !bl2) {
            int n3 = byArray[n] & 0xFF;
            if (n3 < 64) {
                switch (n3) {
                    case 0: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 26: 
                    case 30: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 42: 
                    case 47: 
                    case 51: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 63: {
                        ++n;
                        --n2;
                        continue block36;
                    }
                    case 52: {
                        if (n2 >= 3) {
                            switch (byArray[n + 1]) {
                                case -64: 
                                case -60: 
                                case -56: 
                                case 76: {
                                    n += 3;
                                    n2 -= 3;
                                    bl = true;
                                    continue block36;
                                }
                            }
                            bl = false;
                            bl2 = true;
                            continue block36;
                        }
                        bl2 = true;
                        continue block36;
                    }
                    case 40: {
                        if (n2 >= 3) {
                            switch (byArray[n + 1]) {
                                case 67: {
                                    n += 3;
                                    n2 -= 3;
                                    bl = true;
                                    continue block36;
                                }
                            }
                            bl = false;
                            bl2 = true;
                            continue block36;
                        }
                        bl2 = true;
                        continue block36;
                    }
                    case 43: {
                        if (n2 >= 3 && n2 >= byArray[n + 2] + 2) {
                            byte by = byArray[n + 2];
                            switch (byArray[n + 1]) {
                                case -63: 
                                case -62: 
                                case -58: 
                                case -56: {
                                    n2 -= by + 2;
                                    n += by + 2;
                                    bl = true;
                                    continue block36;
                                }
                                case -47: {
                                    switch (byArray[n + 3]) {
                                        case -127: 
                                        case -118: 
                                        case -114: 
                                        case 1: 
                                        case 5: {
                                            n2 -= by + 2;
                                            n += by + 2;
                                            bl = true;
                                            continue block36;
                                        }
                                    }
                                    bl = false;
                                    bl2 = true;
                                    continue block36;
                                }
                                case -46: {
                                    switch (byArray[n + 3]) {
                                        case -123: 
                                        case 1: 
                                        case 3: 
                                        case 7: 
                                        case 9: 
                                        case 11: 
                                        case 13: 
                                        case 17: 
                                        case 21: 
                                        case 41: 
                                        case 45: 
                                        case 64: 
                                        case 69: 
                                        case 72: 
                                        case 73: 
                                        case 76: {
                                            n2 -= by + 2;
                                            n += by + 2;
                                            bl = true;
                                            continue block36;
                                        }
                                    }
                                    bl = false;
                                    bl2 = true;
                                    continue block36;
                                }
                                case -45: {
                                    switch (byArray[n + 3]) {
                                        case -10: {
                                            n2 -= by + 2;
                                            n += by + 2;
                                            bl = true;
                                            continue block36;
                                        }
                                    }
                                    bl = false;
                                    bl2 = true;
                                    continue block36;
                                }
                                case -44: {
                                    switch (byArray[n + 3]) {
                                        case 10: 
                                        case 14: 
                                        case 114: 
                                        case 118: {
                                            n2 -= by + 2;
                                            n += by + 2;
                                            bl = true;
                                            continue block36;
                                        }
                                    }
                                    bl = false;
                                    bl2 = true;
                                    continue block36;
                                }
                                case -3: {
                                    switch (byArray[n + 3]) {
                                        case 0: 
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            n2 -= by + 2;
                                            n += by + 2;
                                            bl = true;
                                            continue block36;
                                        }
                                    }
                                    bl = false;
                                    bl2 = true;
                                    continue block36;
                                }
                            }
                            bl = false;
                            bl2 = true;
                            continue block36;
                        }
                        bl2 = true;
                        continue block36;
                    }
                    case 3: 
                    case 53: {
                        if (n2 >= 2 && n2 >= byArray[n + 1] + 2) {
                            n2 -= byArray[n + 1] + 2;
                            n += byArray[n + 1] + 2;
                            bl = true;
                            continue block36;
                        }
                        bl2 = true;
                        continue block36;
                    }
                }
                bl = false;
                bl2 = true;
                continue;
            }
            --n2;
            ++n;
        }
        return bl;
    }

    public static String sniff(byte[] byArray, int n, int n2) {
        String string = DT_USERASCII;
        if (NPDataAnalyzer.dataIsAFP(byArray, n, n2)) {
            string = DT_AFPDS;
        } else if (NPDataAnalyzer.dataIsSCS(byArray, n, n2)) {
            string = DT_SCS;
        }
        return string;
    }
}

