/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.QueuedMessageEnumeration;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;

public class HistoryLog {
    static final long serialVersionUID = 4L;
    public static final String CURRENT_DATE = "*CURRENT";
    public static final String BEGIN = "*BEGIN";
    public static final String END = "*END";
    public static final String AVAIL = "*AVAIL";
    public static final int OMIT = 1;
    public static final int SELECT = 0;
    public static final String TYPE_COMPLETION = "*COMP";
    public static final String TYPE_COPY = "*COPY";
    public static final String TYPE_DIAGNOSTIC = "*DIAG";
    public static final String TYPE_ESCAPE = "*ESCAPE";
    public static final String TYPE_INFORMATIONAL = "*INFO";
    public static final String TYPE_INQUIRY = "*INQ";
    public static final String TYPE_NOTIFY = "*NOTIFY";
    public static final String TYPE_REPLY = "*RPY";
    public static final String TYPE_REQUEST = "*RQS";
    private String startingDate_ = "*CURRENT";
    private String startingTime_ = "*AVAIL";
    private String endingDate_ = "*END";
    private String endingTime_ = "*AVAIL";
    private Job[] jobsToList_ = new Job[0];
    private String[] messageIDs_ = new String[0];
    private int idListIndicator_ = 0;
    private int messageSeverity_ = 0;
    private int typesListIndicator_ = 0;
    private String[] messageTypes_ = new String[0];
    private AS400 system_;
    private int length_;
    private byte[] handle_;
    private boolean closeHandle_ = false;

    public HistoryLog(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing HistoryLog object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing job log message list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting history log list length.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public Enumeration getMessages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving history log message list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new QueuedMessageEnumeration(this, this.length_);
    }

    public QueuedMessage[] getMessages(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving history log message list, list offset: " + n + ", number:", n2);
        }
        if (n < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + n + ")", 4);
        }
        if (n2 < 0 && n != -1) {
            throw new ExtendedIllegalArgumentException("number (" + n2 + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || n2 == 0 && n != -1) {
            return new QueuedMessage[0];
        }
        if (n == -1) {
            n2 = this.length_;
            n = 0;
        } else {
            if (n >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", n + " (list length: " + this.length_ + ")");
                }
                return new QueuedMessage[0];
            }
            if (n + n2 > this.length_) {
                n2 = this.length_ - n;
            }
        }
        int n3 = 1024 * n2;
        byte[] byArray = ListUtilities.retrieveListEntries(this.system_, this.handle_, n3, n2, n, null);
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        QueuedMessage[] queuedMessageArray = new QueuedMessage[n2];
        int n4 = 0;
        for (int i = 0; i < queuedMessageArray.length; ++i) {
            int n5 = BinaryConverter.byteArrayToInt(byArray, n4);
            int n6 = BinaryConverter.byteArrayToInt(byArray, n4 + 4);
            String string = converter.byteArrayToString(byArray, n4 + 8, 7).trim();
            int n7 = (byArray[n4 + 15] & 0xF) * 10 + (byArray[n4 + 16] & 0xF);
            if (n7 == 0) {
                n7 = -1;
            }
            String string2 = converter.byteArrayToString(byArray, n4 + 17, 10).trim();
            String string3 = converter.byteArrayToString(byArray, n4 + 27, 10).trim();
            String string4 = converter.byteArrayToString(byArray, n4 + 37, 7);
            String string5 = converter.byteArrayToString(byArray, n4 + 44, 6);
            String string6 = converter.byteArrayToString(byArray, n4 + 56, 10).trim();
            String string7 = converter.byteArrayToString(byArray, n4 + 66, 10).trim();
            String string8 = converter.byteArrayToString(byArray, n4 + 76, 6);
            String string9 = converter.byteArrayToString(byArray, n4 + 82, 10).trim();
            int n8 = BinaryConverter.byteArrayToInt(byArray, n4 + 96);
            int n9 = BinaryConverter.byteArrayToInt(byArray, n4 + 100);
            int n10 = BinaryConverter.byteArrayToInt(byArray, n4 + 104);
            int n11 = BinaryConverter.byteArrayToInt(byArray, n4 + 108);
            String string10 = converter.byteArrayToString(byArray, n4 + n8, n9);
            byte[] byArray2 = new byte[n11];
            System.arraycopy(byArray, n4 + n10, byArray2, 0, n11);
            queuedMessageArray[i] = new QueuedMessage(this.system_, n6, string, n7, string2, string3, string4, string5, string6, string7, string8, string9, string10, byArray2);
            n4 += n5;
        }
        return queuedMessageArray;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading history log message list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        int n4 = this.messageIDs_.length;
        int n5 = n4 * 7;
        int n6 = this.jobsToList_.length;
        int n7 = n6 * 26;
        int n8 = this.messageTypes_.length;
        int n9 = n8 * 10;
        int n10 = n3 = 92;
        int n11 = n10 + n5;
        int n12 = n11 + n7;
        byte[] byArray = new byte[92 + n5 + n7 + n9];
        BinaryConverter.intToByteArray(92, byArray, 0);
        for (n2 = 4; n2 < 56; ++n2) {
            byArray[n2] = 64;
        }
        converter.stringToByteArray(this.startingDate_, byArray, 4);
        converter.stringToByteArray(this.startingTime_, byArray, 14);
        for (n2 = 24; n2 < 30; ++n2) {
            byArray[n2] = 0;
        }
        converter.stringToByteArray(this.endingDate_, byArray, 30);
        converter.stringToByteArray(this.endingTime_, byArray, 40);
        for (n2 = 50; n2 < 56; ++n2) {
            byArray[n2] = 0;
        }
        BinaryConverter.intToByteArray(this.idListIndicator_, byArray, 56);
        BinaryConverter.intToByteArray(n4 == 0 ? 0 : n10, byArray, 60);
        BinaryConverter.intToByteArray(n4 == 0 ? 0 : n4, byArray, 64);
        BinaryConverter.intToByteArray(n6 == 0 ? 0 : n11, byArray, 68);
        BinaryConverter.intToByteArray(n6 == 0 ? 0 : n6, byArray, 72);
        BinaryConverter.intToByteArray(this.messageSeverity_, byArray, 76);
        BinaryConverter.intToByteArray(this.typesListIndicator_, byArray, 80);
        BinaryConverter.intToByteArray(n8 == 0 ? 0 : n12, byArray, 84);
        BinaryConverter.intToByteArray(n8 == 0 ? 0 : n8, byArray, 88);
        n2 = n5 + n7 + n9;
        for (n = n10; n < n10 + n2; ++n) {
            byArray[n] = 64;
        }
        for (n = 0; n < n4; ++n) {
            converter.stringToByteArray(this.messageIDs_[n], byArray, n10 + 7 * n);
        }
        for (n = 0; n < n6; ++n) {
            serializable = this.jobsToList_[n];
            converter.stringToByteArray(((Job)serializable).getName().toUpperCase().trim(), byArray, n11 + 26 * n);
            converter.stringToByteArray(((Job)serializable).getUser().toUpperCase().trim(), byArray, n11 + 26 * n + 10);
            converter.stringToByteArray(((Job)serializable).getNumber(), byArray, n11 + 26 * n + 20);
        }
        for (n = 0; n < n8; ++n) {
            converter.stringToByteArray(this.messageTypes_[n], byArray, n12 + 10 * n);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(converter.stringToByteArray("HSTL0100")), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(byArray), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(converter.stringToByteArray("*JOB      ")), new ErrorCodeParameter()};
        serializable = new ProgramCall(this.system_, "/QSYS.LIB/QMHOLHST.PGM", programParameterArray);
        if (!((ProgramCall)serializable).run()) {
            throw new AS400Exception(((ProgramCall)serializable).getMessageList());
        }
        byte[] byArray2 = programParameterArray[3].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(byArray2, 8, this.handle_, 0, 4);
        byArray2 = ListUtilities.waitForListToComplete(this.system_, this.handle_, byArray2);
        this.length_ = BinaryConverter.byteArrayToInt(byArray2, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded history log message list, length: " + this.length_ + ", handle: ", this.handle_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartingDate(String string, String string2) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting starting date:  " + string + " " + string2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            if (string == null || string.length() == 0) {
                this.startingDate_ = CURRENT_DATE;
            } else if (string.trim().equalsIgnoreCase(CURRENT_DATE)) {
                this.startingDate_ = CURRENT_DATE;
            } else if (string.trim().equalsIgnoreCase(BEGIN)) {
                this.startingDate_ = BEGIN;
            } else {
                if (string.trim().length() > 7) {
                    throw new ExtendedIllegalArgumentException("date (" + string + ")", 1);
                }
                this.startingDate_ = string;
            }
            if (string2 == null || string2.length() == 0) {
                this.startingTime_ = AVAIL;
            } else if (string2.trim().equalsIgnoreCase(AVAIL)) {
                this.startingTime_ = AVAIL;
            } else {
                if (string2.trim().length() > 6) {
                    throw new ExtendedIllegalArgumentException("time (" + string2 + ")", 1);
                }
                this.startingTime_ = string2;
            }
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartingDate(Date date) throws ExtendedIllegalArgumentException {
        if (date == null) {
            Trace.log(2, "Parameter 'date' is null.");
            throw new NullPointerException("date");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Setting starting date:  " + date);
        }
        String string = this.dateToString(date);
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.startingDate_ = string.substring(0, 7);
            this.startingTime_ = string.substring(7);
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public Date getStartingDate() {
        if (this.startingDate_.equals(CURRENT_DATE) || this.startingDate_.equals(BEGIN)) {
            return null;
        }
        return this.stringToDate(this.startingDate_, this.startingTime_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndingDate(String string, String string2) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list ending date " + string + " " + string2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            if (string == null || string.length() == 0) {
                this.endingDate_ = END;
            } else if (string.trim().equalsIgnoreCase(CURRENT_DATE)) {
                this.endingDate_ = CURRENT_DATE;
            } else if (string.trim().equalsIgnoreCase(END)) {
                this.endingDate_ = END;
            } else {
                if (string.trim().length() > 7) {
                    throw new ExtendedIllegalArgumentException("date (" + string + ")", 1);
                }
                this.endingDate_ = string;
            }
            if (string2 == null || string2.length() == 0) {
                this.endingTime_ = AVAIL;
            } else if (string2.trim().equalsIgnoreCase(AVAIL)) {
                this.endingTime_ = AVAIL;
            } else {
                if (string2.trim().length() > 6) {
                    throw new ExtendedIllegalArgumentException("time (" + string2 + ")", 1);
                }
                this.endingTime_ = string2;
            }
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndingDate(Date date) throws ExtendedIllegalArgumentException {
        if (date == null) {
            Trace.log(2, "Parameter 'date' is null.");
            throw new NullPointerException("date");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list ending date: " + date);
        }
        String string = this.dateToString(date);
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.endingDate_ = string.substring(0, 7);
            this.endingTime_ = string.substring(7);
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public Date getEndingDate() {
        if (this.endingDate_.equals(CURRENT_DATE) || this.endingDate_.equals(END)) {
            return null;
        }
        return this.stringToDate(this.endingDate_, this.endingTime_);
    }

    private Date stringToDate(String string, String string2) {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        int n = Integer.parseInt(string.substring(0, 3));
        int n2 = Integer.parseInt(string.substring(3, 5));
        int n3 = Integer.parseInt(string.substring(5, 7));
        boolean bl = string2.equals(AVAIL);
        int n4 = bl ? 0 : Integer.parseInt(string2.substring(0, 2));
        int n5 = bl ? 0 : Integer.parseInt(string2.substring(2, 4));
        int n6 = bl ? 0 : Integer.parseInt(string2.substring(4));
        calendar.set(1, n + 1900);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private String dateToString(Date date) {
        StringBuffer stringBuffer = new StringBuffer(13);
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        stringBuffer.append(n < 2000 ? (char)'0' : '1');
        stringBuffer.append(this.twoDigits(n % 100));
        stringBuffer.append(this.twoDigits(calendar.get(2) + 1));
        stringBuffer.append(this.twoDigits(calendar.get(5)));
        stringBuffer.append(this.twoDigits(calendar.get(11)));
        stringBuffer.append(this.twoDigits(calendar.get(12)));
        stringBuffer.append(this.twoDigits(calendar.get(13)));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageIDs(String[] stringArray) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list ids");
        }
        if (stringArray == null) {
            Trace.log(2, "Parameter 'ids' is null.");
            throw new NullPointerException("ids");
        }
        if (stringArray.length > 100) {
            Trace.log(2, "Length of ids not valid.");
            throw new ExtendedIllegalArgumentException("ids (" + stringArray.length + ")", 1);
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].length();
            if (n2 > 7) {
                Trace.log(2, "Length of message id is not valid.  Message ID = " + stringArray[i]);
                throw new ExtendedIllegalArgumentException("ids[" + i + "] (" + stringArray[i] + ")", 2);
            }
            if (n2 >= 7) continue;
            StringBuffer stringBuffer = new StringBuffer(stringArray[i]);
            for (int j = n2; j < 7; ++j) {
                stringBuffer.append("0");
            }
            stringArray[i] = stringBuffer.toString();
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.messageIDs_ = stringArray;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public String[] getMessageIDs() {
        return this.messageIDs_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageIDsListIndicator(int n) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message ids list indicator: " + n);
        }
        if (n != 1 && n != 0) {
            throw new ExtendedIllegalArgumentException("indicator(" + n + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.idListIndicator_ = n;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public int getMessageIDsListIndicator() {
        return this.idListIndicator_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageTypeListIndicator(int n) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message type list indicator:  " + n);
        }
        if (n != 1 && n != 0) {
            throw new ExtendedIllegalArgumentException("indicator(" + n + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.typesListIndicator_ = n;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public int getMessageTypeListIndicator() {
        return this.typesListIndicator_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageTypes(String[] stringArray) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message types");
        }
        if (stringArray == null) {
            Trace.log(2, "Parameter 'types' is null.");
            throw new NullPointerException("types");
        }
        if (stringArray.length > 10) {
            Trace.log(2, "Length of types not valid.");
            throw new ExtendedIllegalArgumentException("types (" + stringArray.length + ")", 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals(TYPE_COMPLETION) || string.equals(TYPE_COPY) || string.equals(TYPE_DIAGNOSTIC) || string.equals(TYPE_ESCAPE) || string.equals(TYPE_INFORMATIONAL) || string.equals(TYPE_INQUIRY) || string.equals(TYPE_NOTIFY) || string.equals(TYPE_REPLY) || string.equals(TYPE_REQUEST)) continue;
            throw new ExtendedIllegalArgumentException("types[" + i + "] (" + string + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.messageTypes_ = stringArray;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public String[] getMessageTypes() {
        return this.messageTypes_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageSeverity(int n) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message severity: " + n);
        }
        if (n < 0 || n > 99) {
            throw new ExtendedIllegalArgumentException("severity (" + n + ")", 2);
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.messageSeverity_ = n;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public int getMessageSeverity() {
        return this.messageSeverity_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobs(Job[] jobArray) throws ExtendedIllegalArgumentException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting jobs");
        }
        if (jobArray == null) {
            Trace.log(2, "Parameter 'jobs' is null.");
            throw new NullPointerException("jobs");
        }
        if (jobArray.length > 5) {
            Trace.log(2, "Length of jobs not valid.");
            throw new ExtendedIllegalArgumentException("jobs (" + jobArray.length + ")", 1);
        }
        for (int i = 0; i < jobArray.length; ++i) {
            if (jobArray[i] == null) {
                throw new NullPointerException("job(" + i + ")");
            }
            if (jobArray[i].getName() == null) {
                throw new NullPointerException("job name(" + i + ")");
            }
            if (jobArray[i].getNumber() == null) {
                throw new NullPointerException("job number(" + i + ")");
            }
            if (jobArray[i].getUser() != null) continue;
            throw new NullPointerException("job user(" + i + ")");
        }
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            this.jobsToList_ = jobArray;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public Job[] getJobs() {
        return this.jobsToList_;
    }

    private String twoDigits(int n) {
        if (n > 99) {
            throw new ExtendedIllegalArgumentException("value", 2);
        }
        String string = "00" + Integer.toString(n);
        return string.substring(string.length() - 2);
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for history log invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

