/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartition;

@DefaultCoder(value=AvroCoder.class)
public class ChildPartitionsRecord
implements ChangeStreamRecord {
    private static final long serialVersionUID = 5442772555232576887L;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp startTimestamp;
    private String recordSequence;
    private List<ChildPartition> childPartitions;
    @org.apache.avro.reflect.Nullable
    private ChangeStreamRecordMetadata metadata;

    private ChildPartitionsRecord() {
    }

    public ChildPartitionsRecord(Timestamp startTimestamp, String recordSequence, List<ChildPartition> childPartitions, ChangeStreamRecordMetadata metadata) {
        this.startTimestamp = startTimestamp;
        this.recordSequence = recordSequence;
        this.childPartitions = childPartitions;
        this.metadata = metadata;
    }

    @Override
    public Timestamp getRecordTimestamp() {
        return this.getStartTimestamp();
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public String getRecordSequence() {
        return this.recordSequence;
    }

    public List<ChildPartition> getChildPartitions() {
        return this.childPartitions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChildPartitionsRecord)) {
            return false;
        }
        ChildPartitionsRecord that = (ChildPartitionsRecord)o;
        return Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.recordSequence, that.recordSequence) && Objects.equals(this.childPartitions, that.childPartitions);
    }

    public int hashCode() {
        return Objects.hash(this.startTimestamp, this.recordSequence, this.childPartitions);
    }

    public String toString() {
        return "ChildPartitionsRecord{startTimestamp=" + this.startTimestamp + ", recordSequence='" + this.recordSequence + '\'' + ", childPartitions=" + this.childPartitions + ", metadata=" + this.metadata + '}';
    }
}

