/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ChildPartitionsRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DataChangeRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.HeartbeatRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.QueryChangeStreamAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.ChangeStreamRecordMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ReadChangeStreamPartitionRangeTracker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DoFn.UnboundedPerElement
public class ReadChangeStreamPartitionDoFn
extends DoFn<PartitionMetadata, DataChangeRecord>
implements Serializable {
    private static final long serialVersionUID = -7574596218085711975L;
    private static final Logger LOG = LoggerFactory.getLogger(ReadChangeStreamPartitionDoFn.class);
    private static final double AUTOSCALING_SIZE_MULTIPLIER = 2.0;
    private final DaoFactory daoFactory;
    private final MapperFactory mapperFactory;
    private final ActionFactory actionFactory;
    private final ChangeStreamMetrics metrics;
    private final ThroughputEstimator throughputEstimator;
    private transient QueryChangeStreamAction queryChangeStreamAction;

    public ReadChangeStreamPartitionDoFn(DaoFactory daoFactory, MapperFactory mapperFactory, ActionFactory actionFactory, ChangeStreamMetrics metrics, ThroughputEstimator throughputEstimator) {
        this.daoFactory = daoFactory;
        this.mapperFactory = mapperFactory;
        this.actionFactory = actionFactory;
        this.metrics = metrics;
        this.throughputEstimator = throughputEstimator;
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public Instant getInitialWatermarkEstimatorState(@DoFn.Element PartitionMetadata partition) {
        return new Instant((Object)partition.getStartTimestamp().toSqlTimestamp());
    }

    @DoFn.NewWatermarkEstimator
    public ManualWatermarkEstimator<Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant watermarkEstimatorState) {
        return new WatermarkEstimators.Manual(watermarkEstimatorState);
    }

    @DoFn.GetInitialRestriction
    public TimestampRange initialRestriction(@DoFn.Element PartitionMetadata partition) {
        String token = partition.getPartitionToken();
        Timestamp startTimestamp = partition.getStartTimestamp();
        Timestamp endTimestamp = TimestampUtils.next(partition.getEndTimestamp());
        Timestamp partitionScheduledAt = partition.getScheduledAt();
        Timestamp partitionRunningAt = this.daoFactory.getPartitionMetadataDao().updateToRunning(token);
        if (partitionScheduledAt != null && partitionRunningAt != null) {
            this.metrics.updatePartitionScheduledToRunning(new Duration(partitionScheduledAt.toSqlTimestamp().getTime(), partitionRunningAt.toSqlTimestamp().getTime()));
        }
        this.metrics.incActivePartitionReadCounter();
        return TimestampRange.of(startTimestamp, endTimestamp);
    }

    @DoFn.GetSize
    public double getSize(@DoFn.Element PartitionMetadata partition, @DoFn.Restriction TimestampRange range) throws Exception {
        BigDecimal timeGapInSeconds = BigDecimal.valueOf(this.newTracker(partition, range).getProgress().getWorkRemaining());
        BigDecimal throughput = BigDecimal.valueOf(this.throughputEstimator.get());
        LOG.debug("Reported getSize() - remaining work: " + timeGapInSeconds + " throughput:" + throughput);
        return timeGapInSeconds.multiply(throughput).multiply(BigDecimal.valueOf(2.0)).min(BigDecimal.valueOf(Double.MAX_VALUE)).doubleValue();
    }

    @DoFn.NewTracker
    public ReadChangeStreamPartitionRangeTracker newTracker(@DoFn.Element PartitionMetadata partition, @DoFn.Restriction TimestampRange range) {
        return new ReadChangeStreamPartitionRangeTracker(partition, range);
    }

    @DoFn.Setup
    public void setup() {
        PartitionMetadataDao partitionMetadataDao = this.daoFactory.getPartitionMetadataDao();
        ChangeStreamDao changeStreamDao = this.daoFactory.getChangeStreamDao();
        ChangeStreamRecordMapper changeStreamRecordMapper = this.mapperFactory.changeStreamRecordMapper();
        PartitionMetadataMapper partitionMetadataMapper = this.mapperFactory.partitionMetadataMapper();
        DataChangeRecordAction dataChangeRecordAction = this.actionFactory.dataChangeRecordAction();
        HeartbeatRecordAction heartbeatRecordAction = this.actionFactory.heartbeatRecordAction(this.metrics);
        ChildPartitionsRecordAction childPartitionsRecordAction = this.actionFactory.childPartitionsRecordAction(partitionMetadataDao, this.metrics);
        this.queryChangeStreamAction = this.actionFactory.queryChangeStreamAction(changeStreamDao, partitionMetadataDao, changeStreamRecordMapper, partitionMetadataMapper, dataChangeRecordAction, heartbeatRecordAction, childPartitionsRecordAction, this.metrics, this.throughputEstimator);
    }

    @DoFn.ProcessElement
    public DoFn.ProcessContinuation processElement(@DoFn.Element PartitionMetadata partition, RestrictionTracker<TimestampRange, Timestamp> tracker, DoFn.OutputReceiver<DataChangeRecord> receiver, ManualWatermarkEstimator<Instant> watermarkEstimator, DoFn.BundleFinalizer bundleFinalizer) {
        String token = partition.getPartitionToken();
        LOG.debug("[" + token + "] Processing element with restriction " + tracker.currentRestriction());
        return this.queryChangeStreamAction.run(partition, tracker, receiver, watermarkEstimator, bundleFinalizer);
    }
}

