/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ApiServices;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.CheckpointMarkImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriber;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public class UnboundedReaderImpl
extends UnboundedSource.UnboundedReader<SequencedMessage> {
    private final UnboundedSource<SequencedMessage, CheckpointMarkImpl> source;
    private final MemoryBufferedSubscriber subscriber;
    private final TopicBacklogReader backlogReader;
    private final Supplier<BlockingCommitter> committer;
    private Offset fetchOffset;
    private Optional<Instant> lastMessageTimestamp = Optional.empty();
    private boolean advanced = false;

    UnboundedReaderImpl(UnboundedSource<SequencedMessage, CheckpointMarkImpl> source, MemoryBufferedSubscriber subscriber, TopicBacklogReader backlogReader, Supplier<BlockingCommitter> committer, Offset initialOffset) {
        Preconditions.checkArgument((boolean)initialOffset.equals(subscriber.fetchOffset()));
        this.source = source;
        this.subscriber = subscriber;
        this.backlogReader = backlogReader;
        this.committer = committer;
        this.fetchOffset = initialOffset;
    }

    public SequencedMessage getCurrent() throws NoSuchElementException {
        if (!this.advanced) {
            throw new NoSuchElementException();
        }
        return this.subscriber.peek().get();
    }

    public Instant getCurrentTimestamp() throws NoSuchElementException {
        return UnboundedReaderImpl.getTimestamp(this.getCurrent());
    }

    private static Instant getTimestamp(SequencedMessage message) {
        return Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)message.getPublishTime()));
    }

    public void close() throws IOException {
        try (TopicBacklogReader c1 = this.backlogReader;){
            AutoCloseable c3 = ApiServices.asCloseable(this.subscriber);
            Throwable throwable = null;
            if (c3 != null) {
                if (throwable != null) {
                    try {
                        c3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    c3.close();
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed when closing reader.", e);
        }
    }

    public boolean start() throws IOException {
        try {
            this.subscriber.startAsync().awaitRunning(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.advance();
    }

    public boolean advance() throws IOException {
        if (!this.subscriber.state().equals((Object)ApiService.State.RUNNING)) {
            Throwable t = this.subscriber.failureCause();
            if ("DUPLICATE_SUBSCRIBER_CONNECTIONS".equals(ExtractStatus.getErrorInfoReason((CheckedApiException)ExtractStatus.toCanonical((Throwable)t)))) {
                throw new IOException("Partition reassigned to a different worker- this is expected and can be ignored.", t);
            }
            throw new IOException("Subscriber failed when trying to advance.", t);
        }
        if (this.advanced) {
            this.subscriber.pop();
        }
        Optional<SequencedMessage> next = this.subscriber.peek();
        this.advanced = next.isPresent();
        if (!this.advanced) {
            return false;
        }
        Offset nextOffset = Offset.of((long)(next.get().getCursor().getOffset() + 1L));
        Preconditions.checkState((nextOffset.value() > this.fetchOffset.value() ? 1 : 0) != 0);
        this.fetchOffset = nextOffset;
        this.lastMessageTimestamp = Optional.of(UnboundedReaderImpl.getTimestamp(next.get()));
        return true;
    }

    public Instant getWatermark() {
        return this.lastMessageTimestamp.orElse(BoundedWindow.TIMESTAMP_MIN_VALUE);
    }

    public CheckpointMarkImpl getCheckpointMark() {
        this.subscriber.rebuffer();
        return new CheckpointMarkImpl(this.fetchOffset, this.committer);
    }

    public UnboundedSource<SequencedMessage, CheckpointMarkImpl> getCurrentSource() {
        return this.source;
    }

    public long getSplitBacklogBytes() {
        return this.backlogReader.computeMessageStats(this.fetchOffset).getMessageBytes();
    }
}

