/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Ticker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;

final class LimitingTopicBacklogReader
implements TopicBacklogReader {
    private final TopicBacklogReader underlying;
    private final LoadingCache<String, ComputeMessageStatsResponse> backlogCache;
    @Nullable
    @GuardedBy(value="this")
    private Offset currentRequestOffset = null;

    LimitingTopicBacklogReader(TopicBacklogReader underlying, Ticker ticker) {
        this.underlying = underlying;
        this.backlogCache = CacheBuilder.newBuilder().ticker(ticker).maximumSize(1L).expireAfterWrite(1L, TimeUnit.MINUTES).refreshAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, ComputeMessageStatsResponse>(){

            public ComputeMessageStatsResponse load(String val) {
                return LimitingTopicBacklogReader.this.loadFromUnderlying();
            }
        });
    }

    private synchronized ComputeMessageStatsResponse loadFromUnderlying() {
        return this.underlying.computeMessageStats((Offset)Preconditions.checkNotNull((Object)this.currentRequestOffset));
    }

    @Override
    public synchronized ComputeMessageStatsResponse computeMessageStats(Offset offset) throws ApiException {
        this.currentRequestOffset = offset;
        try {
            return (ComputeMessageStatsResponse)this.backlogCache.get((Object)"cache");
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    @Override
    public void close() throws Exception {
        this.underlying.close();
    }
}

