/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.Committer;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;

public class BlockingCommitterImpl
implements BlockingCommitter {
    private final Committer committer;

    BlockingCommitterImpl(Committer committer) {
        if (!committer.isRunning()) {
            throw new IllegalStateException("Committer passed to BlockingCommitter which is not running.", committer.failureCause());
        }
        this.committer = committer;
    }

    @Override
    public void commitOffset(Offset offset) {
        if (!this.committer.isRunning()) {
            throw new IllegalStateException("Committer not running when commitOffset called.", this.committer.failureCause());
        }
        try {
            this.committer.commitOffset(offset).get(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    @Override
    public void close() throws Exception {
        this.committer.stopAsync().awaitTerminated(1L, TimeUnit.MINUTES);
    }
}

