/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.DatabaseRootName;
import com.google.firestore.v1.Write;
import com.google.firestore.v1.WriteResult;
import com.google.rpc.Code;
import com.google.rpc.Status;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreDoFn;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreOptions;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1RpcAttemptContexts;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FirestoreV1WriteFn {
    FirestoreV1WriteFn() {
    }

    static final class WriteElement
    implements RpcQos.RpcWriteAttempt.Element<Write> {
        private static final Comparator<WriteElement> COMPARATOR = Comparator.comparing(WriteElement::getQueuePosition);
        private final int queuePosition;
        private final Write value;
        private final BoundedWindow window;

        WriteElement(int queuePosition, Write value, BoundedWindow window) {
            this.value = value;
            this.queuePosition = queuePosition;
            this.window = window;
        }

        public int getQueuePosition() {
            return this.queuePosition;
        }

        @Override
        public Write getValue() {
            return this.value;
        }

        @Override
        public long getSerializedSize() {
            return this.value.getSerializedSize();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WriteElement)) {
                return false;
            }
            WriteElement that = (WriteElement)o;
            return this.queuePosition == that.queuePosition && this.value.equals((Object)that.value) && this.window.equals(that.window);
        }

        public int hashCode() {
            return Objects.hash(this.queuePosition, this.value, this.window);
        }

        public String toString() {
            return "WriteElement{queuePosition=" + this.queuePosition + ", value=" + this.value + ", window=" + this.window + '}';
        }
    }

    static abstract class BaseBatchWriteFn<OutT>
    extends FirestoreDoFn.ExplicitlyWindowedFirestoreDoFn<Write, OutT>
    implements FirestoreV1RpcAttemptContexts.HasRpcAttemptContext {
        private static final Logger LOG = LoggerFactory.getLogger((String)FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.BatchWrite.getNamespace());
        private final JodaClock clock;
        private final FirestoreStatefulComponentFactory firestoreStatefulComponentFactory;
        private final RpcQosOptions rpcQosOptions;
        private final CounterFactory counterFactory;
        private final FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext rpcAttemptContext;
        private transient RpcQos rpcQos;
        private transient Counter writesSuccessful;
        private transient Counter writesFailedRetryable;
        private transient Counter writesFailedNonRetryable;
        private transient FirestoreStub firestoreStub;
        private transient DatabaseRootName databaseRootName;
        @VisibleForTesting
        transient Queue<@NonNull WriteElement> writes = new PriorityQueue<WriteElement>(WriteElement.access$000());
        @VisibleForTesting
        transient int queueNextEntryPriority = 0;

        BaseBatchWriteFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions, CounterFactory counterFactory) {
            this.clock = clock;
            this.firestoreStatefulComponentFactory = firestoreStatefulComponentFactory;
            this.rpcQosOptions = rpcQosOptions;
            this.counterFactory = counterFactory;
            this.rpcAttemptContext = FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.BatchWrite;
        }

        @Override
        public RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return this.rpcAttemptContext;
        }

        @Override
        public final void populateDisplayData(DisplayData.Builder builder) {
            builder.include("rpcQosOptions", (HasDisplayData)this.rpcQosOptions);
        }

        @Override
        public void setup() {
            this.rpcQos = this.firestoreStatefulComponentFactory.getRpcQos(this.rpcQosOptions);
            this.writes = new PriorityQueue<WriteElement>(WriteElement.COMPARATOR);
            String namespace = this.rpcAttemptContext.getNamespace();
            this.writesSuccessful = this.counterFactory.get(namespace, "writes_successful");
            this.writesFailedRetryable = this.counterFactory.get(namespace, "writes_failed_retryable");
            this.writesFailedNonRetryable = this.counterFactory.get(namespace, "writes_failed_non-retryable");
        }

        @Override
        public final void startBundle(DoFn.StartBundleContext c) {
            String project = ((GcpOptions)c.getPipelineOptions().as(GcpOptions.class)).getProject();
            String databaseId = ((FirestoreOptions)c.getPipelineOptions().as(FirestoreOptions.class)).getFirestoreDb();
            this.databaseRootName = DatabaseRootName.of((String)Objects.requireNonNull(project, "project must be defined on GcpOptions of PipelineOptions"), (String)Objects.requireNonNull(databaseId, "firestoreDb must be defined on FirestoreOptions of PipelineOptions"));
            this.firestoreStub = this.firestoreStatefulComponentFactory.getFirestoreStub(c.getPipelineOptions());
        }

        @Override
        public void processElement(DoFn.ProcessContext context, BoundedWindow window) throws Exception {
            Write write = Objects.requireNonNull((Write)context.element(), "context.element() must be non null");
            ProcessContextAdapter contextAdapter = new ProcessContextAdapter(context);
            int serializedSize = write.getSerializedSize();
            boolean tooLarge = this.rpcQos.bytesOverLimit(serializedSize);
            if (tooLarge) {
                String message = String.format("%s for document '%s' larger than configured max allowed bytes per batch", BaseBatchWriteFn.getWriteType(write), BaseBatchWriteFn.getName(write));
                this.handleWriteFailures(contextAdapter, this.clock.instant(), (List<KV<FirestoreV1.WriteFailure, BoundedWindow>>)ImmutableList.of((Object)KV.of((Object)new FirestoreV1.WriteFailure(write, WriteResult.newBuilder().build(), Status.newBuilder().setCode(Code.INVALID_ARGUMENT.getNumber()).setMessage(message).build()), (Object)window)), () -> LOG.info(message));
            } else {
                this.writes.offer(new WriteElement(this.queueNextEntryPriority++, write, window));
                this.flushBatch(false, contextAdapter);
            }
        }

        @Override
        public void finishBundle(DoFn.FinishBundleContext context) throws Exception {
            try {
                this.flushBatch(true, new FinishBundleContextAdapter(context));
            }
            finally {
                this.databaseRootName = null;
                this.firestoreStub.close();
            }
        }

        private void flushBatch(boolean finishingBundle, ContextAdapter<OutT> context) throws InterruptedException {
            while (!this.writes.isEmpty()) {
                Instant begin;
                RpcQos.RpcWriteAttempt attempt = this.rpcQos.newWriteAttempt(this.getRpcAttemptContext());
                if (!attempt.awaitSafeToProceed(begin = this.clock.instant())) continue;
                RpcQos.RpcWriteAttempt.FlushBuffer<WriteElement> flushBuffer = this.getFlushBuffer(attempt, begin);
                if (flushBuffer.isFull() || finishingBundle && flushBuffer.isNonEmpty()) {
                    DoFlushStatus flushStatus = this.doFlush(attempt, flushBuffer, context);
                    if (flushStatus != DoFlushStatus.ONE_OR_MORE_FAILURES || finishingBundle) continue;
                    break;
                }
                flushBuffer.forEach(this.writes::offer);
                if (finishingBundle) continue;
                return;
            }
            if (this.writes.isEmpty()) {
                this.queueNextEntryPriority = 0;
            }
        }

        private RpcQos.RpcWriteAttempt.FlushBuffer<WriteElement> getFlushBuffer(RpcQos.RpcWriteAttempt attempt, Instant start) {
            WriteElement peek;
            RpcQos.RpcWriteAttempt.FlushBuffer<WriteElement> buffer = attempt.newFlushBuffer(start);
            while ((peek = this.writes.peek()) != null && buffer.offer(peek)) {
                this.writes.poll();
            }
            return buffer;
        }

        private BatchWriteRequest getBatchWriteRequest(RpcQos.RpcWriteAttempt.FlushBuffer<WriteElement> flushBuffer) {
            BatchWriteRequest.Builder commitBuilder = BatchWriteRequest.newBuilder().setDatabase(this.databaseRootName.toString());
            for (WriteElement element : flushBuffer) {
                commitBuilder.addWrites(element.getValue());
            }
            return commitBuilder.build();
        }

        private DoFlushStatus doFlush(RpcQos.RpcWriteAttempt attempt, RpcQos.RpcWriteAttempt.FlushBuffer<WriteElement> flushBuffer, ContextAdapter<OutT> context) throws InterruptedException {
            Instant end;
            BatchWriteResponse response;
            Instant start;
            int writesCount = flushBuffer.getBufferedElementsCount();
            long bytes = flushBuffer.getBufferedElementsBytes();
            BatchWriteRequest request = this.getBatchWriteRequest(flushBuffer);
            while (true) {
                start = this.clock.instant();
                LOG.debug("Sending BatchWrite request with {} writes totalling {} bytes", (Object)writesCount, (Object)bytes);
                try {
                    attempt.recordRequestStart(start, writesCount);
                    response = (BatchWriteResponse)this.firestoreStub.batchWriteCallable().call((Object)request);
                    end = this.clock.instant();
                    attempt.recordRequestSuccessful(end);
                }
                catch (RuntimeException exception) {
                    end = this.clock.instant();
                    String exceptionMessage = exception.getMessage();
                    LOG.warn("Sending BatchWrite request with {} writes totalling {} bytes failed due to error: {}", new Object[]{writesCount, bytes, exceptionMessage != null ? exceptionMessage : exception.getClass().getName()});
                    attempt.recordRequestFailed(end);
                    attempt.recordWriteCounts(end, 0, writesCount);
                    flushBuffer.forEach(this.writes::offer);
                    attempt.checkCanRetry(end, exception);
                    continue;
                }
                break;
            }
            long elapsedMillis = end.minus((ReadableDuration)Duration.millis((long)start.getMillis())).getMillis();
            int okCount = 0;
            long okBytes = 0L;
            BoundedWindow okWindow = null;
            ArrayList<KV> nonRetryableWrites = new ArrayList<KV>();
            List writeResultList = response.getWriteResultsList();
            List statusList = response.getStatusList();
            Iterator iterator = flushBuffer.iterator();
            for (int i = 0; iterator.hasNext() && i < statusList.size(); ++i) {
                WriteElement writeElement = (WriteElement)iterator.next();
                Status writeStatus = (Status)statusList.get(i);
                Code code = Code.forNumber((int)writeStatus.getCode());
                if (code == Code.OK) {
                    ++okCount;
                    okBytes += writeElement.getSerializedSize();
                    okWindow = writeElement.window;
                    continue;
                }
                if (attempt.isCodeRetryable(code)) {
                    this.writes.offer(writeElement);
                    continue;
                }
                nonRetryableWrites.add(KV.of((Object)new FirestoreV1.WriteFailure(writeElement.getValue(), (WriteResult)writeResultList.get(i), writeStatus), (Object)writeElement.window));
            }
            int nonRetryableCount = nonRetryableWrites.size();
            int retryableCount = writesCount - okCount - nonRetryableCount;
            this.writesSuccessful.inc((long)okCount);
            this.writesFailedRetryable.inc((long)retryableCount);
            this.writesFailedNonRetryable.inc((long)nonRetryableCount);
            attempt.recordWriteCounts(end, okCount, nonRetryableCount + retryableCount);
            if (okCount == writesCount) {
                this.handleWriteSummary(context, end, (KV<FirestoreV1.WriteSuccessSummary, BoundedWindow>)KV.of((Object)new FirestoreV1.WriteSuccessSummary(okCount, okBytes), (Object)BaseBatchWriteFn.coerceNonNull(okWindow)), () -> LOG.debug("Sending BatchWrite request with {} writes totalling {} bytes was completely applied in {}ms", new Object[]{writesCount, bytes, elapsedMillis}));
                attempt.completeSuccess();
                return DoFlushStatus.OK;
            }
            if (nonRetryableCount > 0) {
                int finalOkCount = okCount;
                this.handleWriteFailures(context, end, (List<KV<FirestoreV1.WriteFailure, BoundedWindow>>)ImmutableList.copyOf(nonRetryableWrites), () -> LOG.warn("Sending BatchWrite request with {} writes totalling {} bytes was incompletely applied in {}ms ({} ok, {} retryable, {} non-retryable)", new Object[]{writesCount, bytes, elapsedMillis, finalOkCount, retryableCount, nonRetryableCount}));
            } else if (retryableCount > 0) {
                int finalOkCount = okCount;
                Runnable logMessage = () -> LOG.debug("Sending BatchWrite request with {} writes totalling {} bytes was incompletely applied in {}ms ({} ok, {} retryable)", new Object[]{writesCount, bytes, elapsedMillis, finalOkCount, retryableCount});
                if (okCount > 0) {
                    this.handleWriteSummary(context, end, (KV<FirestoreV1.WriteSuccessSummary, BoundedWindow>)KV.of((Object)new FirestoreV1.WriteSuccessSummary(okCount, okBytes), (Object)BaseBatchWriteFn.coerceNonNull(okWindow)), logMessage);
                } else {
                    logMessage.run();
                }
            }
            return DoFlushStatus.ONE_OR_MORE_FAILURES;
        }

        private static BoundedWindow coerceNonNull(@Nullable BoundedWindow successfulWindow) {
            if (successfulWindow == null) {
                throw new IllegalStateException("Unable to locate window for successful request");
            }
            return successfulWindow;
        }

        abstract void handleWriteFailures(ContextAdapter<OutT> var1, Instant var2, List<KV<FirestoreV1.WriteFailure, BoundedWindow>> var3, Runnable var4);

        abstract void handleWriteSummary(ContextAdapter<OutT> var1, Instant var2, KV<FirestoreV1.WriteSuccessSummary, BoundedWindow> var3, Runnable var4);

        private static String getWriteType(Write w) {
            if (w.hasUpdate()) {
                return "UPDATE";
            }
            if (w.hasTransform()) {
                return "TRANSFORM";
            }
            return "DELETE";
        }

        private static String getName(Write w) {
            if (w.hasUpdate()) {
                return w.getUpdate().getName();
            }
            if (w.hasTransform()) {
                return w.getTransform().getDocument();
            }
            return w.getDelete();
        }

        private static final class FinishBundleContextAdapter<T>
        implements ContextAdapter<T> {
            private final DoFn.FinishBundleContext context;

            private FinishBundleContextAdapter(DoFn.FinishBundleContext context) {
                this.context = context;
            }

            @Override
            public void output(T t, Instant timestamp, BoundedWindow window) {
                this.context.output(t, timestamp, window);
            }
        }

        private static final class ProcessContextAdapter<T>
        implements ContextAdapter<T> {
            private final DoFn.ProcessContext context;

            private ProcessContextAdapter(DoFn.ProcessContext context) {
                this.context = context;
            }

            @Override
            public void output(T t, Instant timestamp, BoundedWindow window) {
                this.context.outputWithTimestamp(t, timestamp);
            }
        }

        static interface ContextAdapter<T> {
            public void output(T var1, Instant var2, BoundedWindow var3);
        }

        private static enum DoFlushStatus {
            OK,
            ONE_OR_MORE_FAILURES;

        }
    }

    static final class BatchWriteFnWithDeadLetterQueue
    extends BaseBatchWriteFn<FirestoreV1.WriteFailure> {
        BatchWriteFnWithDeadLetterQueue(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions, CounterFactory counterFactory) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, counterFactory);
        }

        @Override
        void handleWriteFailures(BaseBatchWriteFn.ContextAdapter<FirestoreV1.WriteFailure> context, Instant timestamp, List<KV<FirestoreV1.WriteFailure, BoundedWindow>> writeFailures, Runnable logMessage) {
            logMessage.run();
            for (KV<FirestoreV1.WriteFailure, BoundedWindow> kv : writeFailures) {
                context.output((FirestoreV1.WriteFailure)kv.getKey(), timestamp, (BoundedWindow)kv.getValue());
            }
        }

        @Override
        void handleWriteSummary(BaseBatchWriteFn.ContextAdapter<FirestoreV1.WriteFailure> context, Instant timestamp, KV<FirestoreV1.WriteSuccessSummary, BoundedWindow> tuple, Runnable logMessage) {
            logMessage.run();
        }
    }

    static final class BatchWriteFnWithSummary
    extends BaseBatchWriteFn<FirestoreV1.WriteSuccessSummary> {
        BatchWriteFnWithSummary(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions, CounterFactory counterFactory) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions, counterFactory);
        }

        @Override
        void handleWriteFailures(BaseBatchWriteFn.ContextAdapter<FirestoreV1.WriteSuccessSummary> context, Instant timestamp, List<KV<FirestoreV1.WriteFailure, BoundedWindow>> writeFailures, Runnable logMessage) {
            throw new FirestoreV1.FailedWritesException(writeFailures.stream().map(KV::getKey).collect(Collectors.toList()));
        }

        @Override
        void handleWriteSummary(BaseBatchWriteFn.ContextAdapter<FirestoreV1.WriteSuccessSummary> context, Instant timestamp, KV<FirestoreV1.WriteSuccessSummary, BoundedWindow> tuple, Runnable logMessage) {
            logMessage.run();
            context.output((FirestoreV1.WriteSuccessSummary)tuple.getKey(), timestamp, (BoundedWindow)tuple.getValue());
        }
    }
}

