/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.auto.service.AutoService;
import com.google.datastore.v1.Query;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;
import org.apache.beam.sdk.io.gcp.datastore.EntityToRow;
import org.apache.beam.sdk.io.gcp.datastore.RowToEntity;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.io.InvalidLocationException;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class DataStoreV1SchemaIOProvider
implements SchemaIOProvider {
    public static final String KEY_FIELD_PROPERTY = "keyField";
    static final String DEFAULT_KEY_FIELD = "__key__";
    private static final Pattern locationPattern = Pattern.compile("(?<projectId>.+)/(?<kind>.+)");

    public String identifier() {
        return "datastoreV1";
    }

    public Schema configurationSchema() {
        return Schema.builder().addNullableField(KEY_FIELD_PROPERTY, Schema.FieldType.STRING).build();
    }

    public DataStoreV1SchemaIO from(String location, Row configuration, Schema dataSchema) {
        return new DataStoreV1SchemaIO(location, configuration, dataSchema);
    }

    public boolean requiresDataSchema() {
        return true;
    }

    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    public static class DataStoreV1SchemaIO
    implements SchemaIO,
    Serializable {
        protected final Schema dataSchema;
        protected final String location;
        protected final String kind;
        protected final String projectId;
        protected final String keyField;

        private DataStoreV1SchemaIO(String location, Row config, Schema dataSchema) {
            this.location = location;
            this.dataSchema = dataSchema;
            this.keyField = this.determineKeyField(config.getString(DataStoreV1SchemaIOProvider.KEY_FIELD_PROPERTY));
            Matcher matcher = locationPattern.matcher(this.location);
            this.validateLocation(location, matcher);
            this.kind = matcher.group("kind");
            this.projectId = matcher.group("projectId");
        }

        public Schema schema() {
            return this.dataSchema;
        }

        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public PCollection<Row> expand(PBegin begin) {
                    Query.Builder q = Query.newBuilder();
                    q.addKindBuilder().setName(kind);
                    Query query = q.build();
                    DatastoreV1.Read readInstance = DatastoreIO.v1().read().withProjectId(projectId).withQuery(query);
                    return (PCollection)((PCollection)begin.apply("Read Datastore Entities", (PTransform)readInstance)).apply("Convert Datastore Entities to Rows", (PTransform)EntityToRow.create(dataSchema, keyField));
                }
            };
        }

        public PTransform<PCollection<Row>, POutput> buildWriter() {
            return new PTransform<PCollection<Row>, POutput>(){

                public POutput expand(PCollection<Row> input) {
                    return ((PCollection)input.apply("Convert Rows to Datastore Entities", (PTransform)RowToEntity.create(keyField, kind))).apply("Write Datastore Entities", (PTransform)DatastoreIO.v1().write().withProjectId(projectId));
                }
            };
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getKind() {
            return this.kind;
        }

        private String determineKeyField(String configKey) {
            if (configKey != null && configKey.isEmpty()) {
                throw new InvalidConfigurationException(String.format("'%s' property cannot be null.", DataStoreV1SchemaIOProvider.KEY_FIELD_PROPERTY));
            }
            if (configKey != null) {
                return configKey;
            }
            return DataStoreV1SchemaIOProvider.DEFAULT_KEY_FIELD;
        }

        private void validateLocation(String location, Matcher matcher) {
            if (location == null) {
                throw new InvalidLocationException("DataStoreV1 location must be set. ");
            }
            if (!matcher.matches()) {
                throw new InvalidLocationException("DataStoreV1 location must be in the following format: 'projectId/kind' but was:" + location);
            }
        }
    }
}

