/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class StorageApiWriteRecordsInconsistent<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, StorageApiWritePayload>>, PCollection<Void>> {
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryServices bqServices;

    public StorageApiWriteRecordsInconsistent(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices) {
        this.dynamicDestinations = dynamicDestinations;
        this.bqServices = bqServices;
    }

    public PCollection<Void> expand(PCollection<KV<DestinationT, StorageApiWritePayload>> input) {
        String operationName = input.getName() + "/" + this.getName();
        BigQueryOptions bigQueryOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
        input.apply("Write Records", (PTransform)ParDo.of(new StorageApiWriteUnshardedRecords.WriteRecordsDoFn<DestinationT, ElementT>(operationName, this.dynamicDestinations, this.bqServices, true, bigQueryOptions.getStorageApiAppendThresholdBytes(), bigQueryOptions.getStorageApiAppendThresholdRecordCount(), bigQueryOptions.getNumStorageWriteApiStreamAppendClients())).withSideInputs(this.dynamicDestinations.getSideInputs()));
        return (PCollection)input.getPipeline().apply("voids", (PTransform)Create.empty((Coder)VoidCoder.of()));
    }
}

