/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryQueryHelper {
    private static final Integer JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryQueryHelper.class);

    BigQueryQueryHelper() {
    }

    public static JobStatistics dryRunQueryIfNeeded(BigQueryServices bqServices, BigQueryOptions options, AtomicReference<@Nullable JobStatistics> dryRunJobStats, String query, Boolean flattenResults, Boolean useLegacySql, @Nullable String location) throws InterruptedException, IOException {
        @Nullable JobStatistics maybeJobStatistics = dryRunJobStats.get();
        if (maybeJobStatistics != null) {
            return maybeJobStatistics;
        }
        JobStatistics jobStatistics = bqServices.getJobService(options).dryRunQuery(options.getBigQueryProject() == null ? options.getProject() : options.getBigQueryProject(), BigQueryQueryHelper.createBasicQueryConfig(query, flattenResults, useLegacySql), location);
        dryRunJobStats.compareAndSet(null, jobStatistics);
        return jobStatistics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TableReference executeQuery(BigQueryServices bqServices, BigQueryOptions options, AtomicReference<@Nullable JobStatistics> dryRunJobStats, String stepUuid, String query, Boolean flattenResults, Boolean useLegacySql, BigQueryIO.TypedRead.QueryPriority priority, @Nullable String location, @Nullable String queryTempDatasetId, @Nullable String kmsKey) throws InterruptedException, IOException {
        @Nullable String effectiveLocation = location;
        try (BigQueryServices.DatasetService tableService = bqServices.getDatasetService(options);){
            boolean beamToCreateTempDataset;
            List referencedTables;
            if (effectiveLocation == null && (referencedTables = BigQueryQueryHelper.dryRunQueryIfNeeded(bqServices, options, dryRunJobStats, query, flattenResults, useLegacySql, location).getQuery().getReferencedTables()) != null && !referencedTables.isEmpty()) {
                TableReference referencedTable = (TableReference)referencedTables.get(0);
                effectiveLocation = tableService.getDataset(referencedTable.getProjectId(), referencedTable.getDatasetId()).getLocation();
            }
            String tempTableID = BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), stepUuid, BigQueryResourceNaming.JobType.QUERY);
            String queryJobId = BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), stepUuid, BigQueryResourceNaming.JobType.QUERY, BigQueryHelpers.randomUUIDString());
            Optional<String> queryTempDatasetOpt = Optional.ofNullable(queryTempDatasetId);
            TableReference queryResultTable = BigQueryResourceNaming.createTempTableReference(options.getBigQueryProject() == null ? options.getProject() : options.getBigQueryProject(), tempTableID, queryTempDatasetOpt);
            boolean bl = beamToCreateTempDataset = !queryTempDatasetOpt.isPresent();
            if (beamToCreateTempDataset) {
                LOG.info("Creating temporary dataset {} for query results", (Object)queryResultTable.getDatasetId());
                tableService.createDataset(queryResultTable.getProjectId(), queryResultTable.getDatasetId(), effectiveLocation, "Temporary tables for query results of job " + options.getJobName(), TimeUnit.DAYS.toMillis(1L));
            } else {
                Table destTable = tableService.getTable(queryResultTable);
                Preconditions.checkArgument((destTable == null ? 1 : 0) != 0, (String)"Refusing to write on existing table {} in the specified temp dataset {}", (Object)queryResultTable.getTableId(), (Object)queryResultTable.getDatasetId());
            }
            LOG.info("Exporting query results into temporary table {} using job {}", (Object)queryResultTable, (Object)queryJobId);
            JobReference jobReference = new JobReference().setProjectId(options.getBigQueryProject() == null ? options.getProject() : options.getBigQueryProject()).setLocation(effectiveLocation).setJobId(queryJobId);
            JobConfigurationQuery queryConfiguration = BigQueryQueryHelper.createBasicQueryConfig(query, flattenResults, useLegacySql).setAllowLargeResults(Boolean.valueOf(true)).setDestinationTable(queryResultTable).setCreateDisposition("CREATE_IF_NEEDED").setWriteDisposition("WRITE_TRUNCATE").setPriority(priority.name());
            if (kmsKey != null) {
                queryConfiguration.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
            }
            BigQueryServices.JobService jobService = bqServices.getJobService(options);
            jobService.startQueryJob(jobReference, queryConfiguration);
            Job job = jobService.pollJob(jobReference, JOB_POLL_MAX_RETRIES);
            if (BigQueryHelpers.parseStatus(job) != BigQueryHelpers.Status.SUCCEEDED) {
                throw new IOException(String.format("Query job %s failed, status: %s", queryJobId, BigQueryHelpers.statusToPrettyString(job.getStatus())));
            }
            LOG.info("Query job {} completed", (Object)queryJobId);
            TableReference tableReference = queryResultTable;
            return tableReference;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JobConfigurationQuery createBasicQueryConfig(String query, Boolean flattenResults, Boolean useLegacySql) {
        return new JobConfigurationQuery().setQuery(query).setFlattenResults(flattenResults).setUseLegacySql(useLegacySql);
    }
}

