/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value.timestamp;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.AttributedCharacterIterator;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SimpleTimestampFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = -848077738238548608L;
    private int startNanosecondPatternPosition;
    private int endNanosecondPatternPosition;
    private boolean compatibleToSuperPattern = true;
    private String originalPattern;
    private DecimalFormat nanoseconds;
    private char patternNanosecond;
    private static final int PATTERN_MILLISECOND_POSITION = 8;
    private static final String DEFAULT_TIMESTAMP_FORMAT_FOR_TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULT_MILLISECOND_DATE_FORMAT = "SSS";
    private static final SimpleDateFormat defaultTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    private static final SimpleDateFormat defaultMillisecondDateFormat = new SimpleDateFormat("SSS", Locale.US);
    private static final String NANOSECOND_PLACEHOLDER = "NANO";
    private static final char FORMATTER_ESCAPE_CHARACTER = '\'';
    private static final String ESCAPED_NANOSECOND_PLACEHOLDER = "'NANO'";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    private static Method getDefaultLocaleMethod;
    private static Class<?> localeCategoryClass;
    private static Object formatCategory;
    private static boolean formatCategoryLocaleAvailable;

    @Override
    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        this.patternNanosecond = newFormatSymbols.getLocalPatternChars().charAt(8);
        super.setDateFormatSymbols(newFormatSymbols);
    }

    private void init(String pattern, DateFormatSymbols formatSymbols, Boolean compiledPattern) {
        String patternToApply;
        this.originalPattern = pattern;
        String datePattern = pattern;
        super.setDateFormatSymbols(formatSymbols);
        this.patternNanosecond = formatSymbols.getLocalPatternChars().charAt(8);
        StringBuilder sb = new StringBuilder();
        this.startNanosecondPatternPosition = datePattern.indexOf(this.patternNanosecond);
        this.endNanosecondPatternPosition = datePattern.lastIndexOf(this.patternNanosecond);
        this.initNanosecondsFormat();
        if (this.startNanosecondPatternPosition != -1) {
            sb.append(datePattern.substring(0, this.startNanosecondPatternPosition));
            sb.append('\'');
            sb.append(NANOSECOND_PLACEHOLDER);
            sb.append('\'');
            sb.append(datePattern.substring(this.endNanosecondPatternPosition + 1));
            datePattern = sb.toString();
            sb.setLength(0);
        }
        if (this.startNanosecondPatternPosition == -1 || this.endNanosecondPatternPosition - this.startNanosecondPatternPosition < 3) {
            this.compatibleToSuperPattern = true;
            patternToApply = this.originalPattern;
        } else {
            this.compatibleToSuperPattern = false;
            patternToApply = datePattern;
        }
        if (compiledPattern.booleanValue()) {
            super.applyLocalizedPattern(patternToApply);
        } else {
            super.applyPattern(patternToApply);
        }
    }

    public SimpleTimestampFormat(String pattern) {
        this(pattern, SimpleTimestampFormat.getCompatibleLocale());
    }

    private static Locale getCompatibleLocale() {
        Locale locale = null;
        if (formatCategoryLocaleAvailable) {
            try {
                locale = (Locale)getDefaultLocaleMethod.invoke(localeCategoryClass, formatCategory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public SimpleTimestampFormat(String pattern, Locale locale) {
        this(pattern, DateFormatSymbols.getInstance(locale));
    }

    public SimpleTimestampFormat(String pattern, DateFormatSymbols formatSymbols) {
        super(pattern, formatSymbols);
        this.init(pattern, formatSymbols, false);
    }

    @Override
    public StringBuffer format(Date timestamp, StringBuffer toAppendTo, FieldPosition pos) {
        String nan;
        StringBuffer dateBuffer;
        if (this.compatibleToSuperPattern) {
            return super.format(timestamp, toAppendTo, pos);
        }
        if (timestamp instanceof Timestamp) {
            Timestamp tmp = (Timestamp)timestamp;
            Date date = new Date(tmp.getTime());
            dateBuffer = super.format(date, toAppendTo, pos);
            nan = this.formatNanoseconds(tmp.getNanos());
        } else {
            dateBuffer = super.format(timestamp, toAppendTo, pos);
            String milliseconds = defaultMillisecondDateFormat.format(timestamp);
            nan = this.formatNanoseconds((double)Integer.valueOf(milliseconds).intValue() * Math.pow(10.0, 6.0));
        }
        int placeholderPosition = this.replaceHolder(dateBuffer, false);
        return dateBuffer.insert(pos.getBeginIndex() + placeholderPosition, nan);
    }

    private String formatNanoseconds(Double v) {
        return this.formatNanoseconds(v.intValue());
    }

    private String formatNanoseconds(Integer nanos) {
        String nan = this.nanoseconds.format(nanos);
        return nan.substring(0, this.endNanosecondPatternPosition - this.startNanosecondPatternPosition + 1);
    }

    private void initNanosecondsFormat() {
        StringBuilder nanos = new StringBuilder();
        for (int i = this.startNanosecondPatternPosition; i <= this.endNanosecondPatternPosition; ++i) {
            nanos.append('0');
        }
        this.nanoseconds = new DecimalFormat(nanos.toString());
    }

    private int replaceHolder(StringBuffer dateBuffer, Boolean inPattern) {
        String placeHolder = inPattern != false ? ESCAPED_NANOSECOND_PLACEHOLDER : NANOSECOND_PLACEHOLDER;
        int placeholderPosition = dateBuffer.indexOf(placeHolder);
        if (placeholderPosition == -1) {
            return 0;
        }
        dateBuffer.delete(placeholderPosition, placeholderPosition + placeHolder.length());
        return placeholderPosition;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        if (obj instanceof Timestamp) {
            throw new IllegalArgumentException("This functionality for Timestamp object has not been implemented yet");
        }
        if (this.compatibleToSuperPattern) {
            return super.formatToCharacterIterator(obj);
        }
        throw new IllegalArgumentException("This functionality for specified format pattern has not been implemented yet");
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        if (this.compatibleToSuperPattern) {
            Date tempDate = super.parse(text, pos);
            return new Timestamp(tempDate.getTime());
        }
        StringBuilder dateText = new StringBuilder(text.substring(pos.getIndex()));
        ParsePosition positionError = new ParsePosition(0);
        Date tempDate = super.parse(dateText.toString(), positionError);
        if (tempDate != null) {
            pos.setErrorIndex(pos.getIndex());
            return null;
        }
        int startNanosecondsPosition = positionError.getErrorIndex();
        int endNanosecondsPosition = this.endNanosecondPatternPosition - this.startNanosecondPatternPosition + 1 + startNanosecondsPosition;
        endNanosecondsPosition = endNanosecondsPosition >= dateText.length() ? dateText.length() : endNanosecondsPosition;
        String nanoseconds = String.valueOf(dateText.subSequence(startNanosecondsPosition, endNanosecondsPosition));
        dateText.delete(startNanosecondsPosition, endNanosecondsPosition);
        ParsePosition position = new ParsePosition(0);
        dateText.append(NANOSECOND_PLACEHOLDER);
        tempDate = super.parse(dateText.toString(), position);
        if (tempDate == null) {
            pos.setErrorIndex(position.getErrorIndex());
            return null;
        }
        String timestampFormatDate = defaultTimestampFormat.format(tempDate);
        String result = timestampFormatDate + "." + nanoseconds;
        Timestamp res = Timestamp.valueOf(timestampFormatDate + "." + nanoseconds);
        pos.setIndex(pos.getIndex() + result.length());
        return res;
    }

    @Override
    public String toPattern() {
        return this.originalPattern;
    }

    @Override
    public String toLocalizedPattern() {
        int placeholderPosition;
        if (this.compatibleToSuperPattern) {
            return super.toLocalizedPattern();
        }
        StringBuffer pattern = new StringBuffer(super.toLocalizedPattern());
        for (int i = placeholderPosition = this.replaceHolder(pattern, true); i <= this.endNanosecondPatternPosition - this.startNanosecondPatternPosition + placeholderPosition; ++i) {
            pattern.insert(i, this.patternNanosecond);
        }
        return pattern.toString();
    }

    @Override
    public void applyPattern(String pattern) {
        DateFormatSymbols formatSymbols = super.getDateFormatSymbols();
        this.init(pattern, formatSymbols, false);
    }

    @Override
    public void applyLocalizedPattern(String pattern) {
        DateFormatSymbols formatSymbols = super.getDateFormatSymbols();
        this.init(pattern, formatSymbols, true);
    }

    @Override
    public Date parse(String source) throws ParseException {
        return super.parse(source);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    static {
        formatCategoryLocaleAvailable = true;
        try {
            localeCategoryClass = Class.forName("java.util.Locale$Category");
            Class<?> localeClass = Class.forName("java.util.Locale");
            Class[] paramTypes = new Class[]{localeCategoryClass};
            getDefaultLocaleMethod = localeClass.getMethod("getDefault", paramTypes);
            Field formatField = localeCategoryClass.getField("FORMAT");
            formatCategory = formatField.get(null);
        }
        catch (Exception e) {
            formatCategoryLocaleAvailable = false;
        }
    }
}

