/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.i18n.BaseMessages;

public class BaseGuiElements {
    protected String getTranslation(String string, String i18nPackage, Class<?> resourceClass) {
        String[] parts;
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (string.startsWith("i18n:") && (parts = string.split(":")).length == 3) {
            String alternativePackage = Const.NVL(parts[1], i18nPackage);
            String key = parts[2];
            return BaseMessages.getString(alternativePackage, key, resourceClass, new String[0]);
        }
        String translation = BaseMessages.getString(i18nPackage, string, resourceClass, new String[0]);
        if (translation.startsWith("!") && translation.endsWith("!")) {
            return string;
        }
        return translation;
    }

    protected String calculateGetterMethod(GuiWidgetElement guiElement, String fieldName) {
        if (StringUtils.isNotEmpty((String)guiElement.getterMethod())) {
            return guiElement.getterMethod();
        }
        String getter = "get" + StringUtil.initCap(fieldName);
        return getter;
    }

    protected String calculateSetterMethod(GuiWidgetElement guiElement, String fieldName) {
        if (StringUtils.isNotEmpty((String)guiElement.setterMethod())) {
            return guiElement.setterMethod();
        }
        String getter = "set" + StringUtil.initCap(fieldName);
        return getter;
    }
}

