/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.fileinput;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.fileinput.NonAccessibleFileObject;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;

public class FileInputList {
    private final List<FileObject> files = new ArrayList<FileObject>();
    private final List<FileObject> nonExistentFiles = new ArrayList<FileObject>(1);
    private final List<FileObject> nonAccessibleFiles = new ArrayList<FileObject>(1);
    private static final ILogChannel log = new LogChannel("FileInputList");
    private static final String YES = "Y";

    public static String getRequiredFilesDescription(List<FileObject> nonExistantFiles) {
        StringBuilder buffer = new StringBuilder();
        for (FileObject file : nonExistantFiles) {
            buffer.append(file.getName().getURI());
            buffer.append(Const.CR);
        }
        return buffer.toString();
    }

    private static boolean[] includeSubdirsFalse(int iLength) {
        boolean[] includeSubdirs = new boolean[iLength];
        for (int i = 0; i < iLength; ++i) {
            includeSubdirs[i] = false;
        }
        return includeSubdirs;
    }

    public static String[] createFilePathList(IVariables variables, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired) {
        boolean[] includeSubdirs = FileInputList.includeSubdirsFalse(fileName.length);
        return FileInputList.createFilePathList(variables, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static String[] createFilePathList(IVariables variables, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs) {
        return FileInputList.createFilePathList(variables, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static String[] createFilePathList(IVariables variables, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs, FileTypeFilter[] filters) {
        List<FileObject> fileList = FileInputList.createFileList(variables, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, filters).getFiles();
        String[] filePaths = new String[fileList.size()];
        for (int i = 0; i < filePaths.length; ++i) {
            filePaths[i] = fileList.get(i).getName().getURI();
        }
        return filePaths;
    }

    public static FileInputList createFileList(IVariables variables, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired) {
        boolean[] includeSubdirs = FileInputList.includeSubdirsFalse(fileName.length);
        return FileInputList.createFileList(variables, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static FileInputList createFileList(IVariables variables, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs) {
        return FileInputList.createFileList(variables, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static FileInputList createFileList(IVariables variables, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs, FileTypeFilter[] fileTypeFilters) {
        FileInputList fileInputList = new FileInputList();
        String[] realFile = variables.resolve(fileName);
        String[] realMask = variables.resolve(fileMask);
        String[] realExcludeMask = variables.resolve(excludeFileMask);
        for (int i = 0; i < realFile.length; ++i) {
            FileTypeFilter filter;
            String oneFile = realFile[i];
            final String oneMask = realMask[i];
            final String excludeOneMask = realExcludeMask[i];
            boolean oneRequired = YES.equalsIgnoreCase(fileRequired[i]);
            final boolean subDirs = includeSubdirs[i];
            FileTypeFilter fileTypeFilter = filter = fileTypeFilters == null || fileTypeFilters[i] == null ? FileTypeFilter.ONLY_FILES : fileTypeFilters[i];
            if (Utils.isEmpty(oneFile)) continue;
            try {
                int j;
                FileObject directoryFileObject = HopVfs.getFileObject(oneFile);
                boolean processFolder = true;
                if (oneRequired) {
                    if (!directoryFileObject.exists()) {
                        fileInputList.addNonExistantFile(directoryFileObject);
                        processFolder = false;
                    } else if (!directoryFileObject.isReadable()) {
                        fileInputList.addNonAccessibleFile(directoryFileObject);
                        processFolder = false;
                    }
                }
                if (!processFolder) continue;
                if (directoryFileObject != null && directoryFileObject.getType() == FileType.FOLDER) {
                    Object[] fileObjects = directoryFileObject.findFiles((FileSelector)new AllFileSelector(){

                        public boolean traverseDescendents(FileSelectInfo info) {
                            return info.getDepth() == 0 || subDirs;
                        }

                        public boolean includeFile(FileSelectInfo info) {
                            if (info.getDepth() == 0) {
                                return false;
                            }
                            FileObject fileObject = info.getFile();
                            try {
                                if (fileObject != null && filter.isFileTypeAllowed(fileObject.getType())) {
                                    String name = info.getFile().getName().getBaseName();
                                    boolean matches = true;
                                    if (!Utils.isEmpty(oneMask)) {
                                        matches = Pattern.matches(oneMask, name);
                                    }
                                    boolean excludematches = false;
                                    if (!Utils.isEmpty(excludeOneMask)) {
                                        excludematches = Pattern.matches(excludeOneMask, name);
                                    }
                                    return matches && !excludematches;
                                }
                                return false;
                            }
                            catch (IOException ex) {
                                return false;
                            }
                        }
                    });
                    if (fileObjects != null) {
                        for (j = 0; j < fileObjects.length; ++j) {
                            Object fileObject = fileObjects[j];
                            if (!fileObject.exists()) continue;
                            fileInputList.addFile((FileObject)fileObject);
                        }
                    }
                    if (Utils.isEmpty(fileObjects) && oneRequired) {
                        fileInputList.addNonAccessibleFile(directoryFileObject);
                    }
                    fileInputList.sortFiles();
                    continue;
                }
                if (directoryFileObject instanceof CompressedFileFileObject) {
                    FileObject[] children = directoryFileObject.getChildren();
                    for (j = 0; j < children.length; ++j) {
                        String name = children[j].getName().getBaseName();
                        boolean matches = true;
                        if (!Utils.isEmpty(oneMask)) {
                            matches = Pattern.matches(oneMask, name);
                        }
                        boolean excludematches = false;
                        if (!Utils.isEmpty(excludeOneMask)) {
                            excludematches = Pattern.matches(excludeOneMask, name);
                        }
                        if (!matches || excludematches) continue;
                        fileInputList.addFile(children[j]);
                    }
                    continue;
                }
                FileObject fileObject = HopVfs.getFileObject(oneFile);
                if (fileObject.exists()) {
                    if (fileObject.isReadable()) {
                        fileInputList.addFile(fileObject);
                        continue;
                    }
                    if (!oneRequired) continue;
                    fileInputList.addNonAccessibleFile(fileObject);
                    continue;
                }
                if (!oneRequired) continue;
                fileInputList.addNonExistantFile(fileObject);
                continue;
            }
            catch (Exception e) {
                if (oneRequired) {
                    fileInputList.addNonAccessibleFile(new NonAccessibleFileObject(oneFile));
                }
                log.logError(Const.getStackTracker(e));
            }
        }
        return fileInputList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInputList createFolderList(IVariables variables, String[] folderName, String[] folderRequired) {
        FileInputList fileInputList = new FileInputList();
        String[] realfolder = variables.resolve(folderName);
        for (int i = 0; i < realfolder.length; ++i) {
            String onefile = realfolder[i];
            boolean onerequired = YES.equalsIgnoreCase(folderRequired[i]);
            boolean subdirs = true;
            final FileTypeFilter filter = FileTypeFilter.ONLY_FOLDERS;
            if (Utils.isEmpty(onefile)) continue;
            FileObject directoryFileObject = null;
            try {
                directoryFileObject = HopVfs.getFileObject(onefile);
                if (directoryFileObject != null && directoryFileObject.getType() == FileType.FOLDER) {
                    Object[] fileObjects = directoryFileObject.findFiles((FileSelector)new AllFileSelector(){

                        public boolean traverseDescendents(FileSelectInfo info) {
                            if (info.getDepth() != 0) {
                                // empty if block
                            }
                            return true;
                        }

                        public boolean includeFile(FileSelectInfo info) {
                            if (info.getDepth() == 0) {
                                return false;
                            }
                            FileObject fileObject = info.getFile();
                            try {
                                return fileObject != null && filter.isFileTypeAllowed(fileObject.getType());
                            }
                            catch (IOException ex) {
                                return false;
                            }
                        }
                    });
                    if (fileObjects != null) {
                        for (int j = 0; j < fileObjects.length; ++j) {
                            if (!fileObjects[j].exists()) continue;
                            fileInputList.addFile((FileObject)fileObjects[j]);
                        }
                    }
                    if (Utils.isEmpty(fileObjects) && onerequired) {
                        fileInputList.addNonAccessibleFile(directoryFileObject);
                    }
                    fileInputList.sortFiles();
                    continue;
                }
                if (!onerequired || directoryFileObject.exists()) continue;
                fileInputList.addNonExistantFile(directoryFileObject);
                continue;
            }
            catch (Exception e) {
                log.logError(Const.getStackTracker(e));
                continue;
            }
            finally {
                try {
                    if (directoryFileObject != null) {
                        directoryFileObject.close();
                    }
                    directoryFileObject = null;
                }
                catch (Exception exception) {}
            }
        }
        return fileInputList;
    }

    public List<FileObject> getFiles() {
        return this.files;
    }

    public String[] getFileStrings() {
        String[] fileStrings = new String[this.files.size()];
        for (int i = 0; i < fileStrings.length; ++i) {
            fileStrings[i] = HopVfs.getFilename(this.files.get(i));
        }
        return fileStrings;
    }

    public String[] getUrlStrings() {
        String[] fileStrings = new String[this.files.size()];
        for (int i = 0; i < fileStrings.length; ++i) {
            fileStrings[i] = this.files.get(i).getPublicURIString();
        }
        return fileStrings;
    }

    public List<FileObject> getNonAccessibleFiles() {
        return this.nonAccessibleFiles;
    }

    public List<FileObject> getNonExistentFiles() {
        return this.nonExistentFiles;
    }

    public void addFile(FileObject file) {
        this.files.add(file);
    }

    public void addNonAccessibleFile(FileObject file) {
        this.nonAccessibleFiles.add(file);
    }

    public void addNonExistantFile(FileObject file) {
        this.nonExistentFiles.add(file);
    }

    public void sortFiles() {
        Collections.sort(this.files, HopVfs.getComparator());
        Collections.sort(this.nonAccessibleFiles, HopVfs.getComparator());
        Collections.sort(this.nonExistentFiles, HopVfs.getComparator());
    }

    public FileObject getFile(int i) {
        return this.files.get(i);
    }

    public int nrOfFiles() {
        return this.files.size();
    }

    public int nrOfMissingFiles() {
        return this.nonAccessibleFiles.size() + this.nonExistentFiles.size();
    }

    public static FileInputList createFileList(IVariables variables, String[] fileName, String[] fileMask, String[] fileRequired, boolean[] includeSubdirs) {
        return FileInputList.createFileList(variables, fileName, fileMask, new String[fileName.length], fileRequired, includeSubdirs, null);
    }

    public static String[] createFilePathList(IVariables variables, String[] fileName, String[] fileMask, String[] fileRequired) {
        boolean[] includeSubdirs = FileInputList.includeSubdirsFalse(fileName.length);
        return FileInputList.createFilePathList(variables, fileName, fileMask, new String[fileName.length], fileRequired, includeSubdirs, null);
    }

    public static enum FileTypeFilter {
        FILES_AND_FOLDERS("all_files", FileType.FILE, FileType.FOLDER),
        ONLY_FILES("only_files", FileType.FILE),
        ONLY_FOLDERS("only_folders", FileType.FOLDER);

        private String name;
        private final Collection<FileType> allowedFileTypes;

        private FileTypeFilter(String name, FileType ... allowedFileTypes) {
            this.name = name;
            this.allowedFileTypes = Collections.unmodifiableCollection(Arrays.asList(allowedFileTypes));
        }

        public boolean isFileTypeAllowed(FileType fileType) {
            return this.allowedFileTypes.contains(fileType);
        }

        public String toString() {
            return this.name;
        }

        public static FileTypeFilter getByOrdinal(int ordinal) {
            for (FileTypeFilter filter : FileTypeFilter.values()) {
                if (filter.ordinal() != ordinal) continue;
                return filter;
            }
            return ONLY_FILES;
        }

        public static FileTypeFilter getByName(String name) {
            for (FileTypeFilter filter : FileTypeFilter.values()) {
                if (!filter.name.equals(name)) continue;
                return filter;
            }
            return ONLY_FILES;
        }
    }
}

