/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ChainingOutput;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.util.OutputTag;

final class CopyingChainingOutput<T>
extends ChainingOutput<T> {
    private final TypeSerializer<T> serializer;

    public CopyingChainingOutput(OneInputStreamOperator<T, ?> operator, TypeSerializer<T> serializer, @Nullable OutputTag<T> outputTag) {
        super(operator, outputTag);
        this.serializer = serializer;
    }

    public CopyingChainingOutput(Input<T> input, TypeSerializer<T> serializer, OperatorMetricGroup operatorMetricGroup, @Nullable OutputTag<T> outputTag) {
        super(input, operatorMetricGroup, outputTag);
        this.serializer = serializer;
    }

    @Override
    public void collect(StreamRecord<T> record) {
        if (this.outputTag != null) {
            return;
        }
        this.pushToOperator(record);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        if (this.outputTag == null || !this.outputTag.equals(outputTag)) {
            return;
        }
        this.pushToOperator(record);
    }

    @Override
    protected <X> void pushToOperator(StreamRecord<X> record) {
        try {
            StreamRecord<X> castRecord = record;
            this.numRecordsIn.inc();
            StreamRecord<Object> copy = castRecord.copy(this.serializer.copy(castRecord.getValue()));
            this.input.setKeyContextElement(copy);
            this.input.processElement(copy);
        }
        catch (ClassCastException e) {
            if (this.outputTag != null) {
                ClassCastException replace = new ClassCastException(String.format("%s. Failed to push OutputTag with id '%s' to operator. This can occur when multiple OutputTags with different types but identical names are being used.", e.getMessage(), this.outputTag.getId()));
                throw new ExceptionInChainedOperatorException(replace);
            }
            throw new ExceptionInChainedOperatorException(e);
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }
}

