/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.util.Set;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.FinishedTriggers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

public class FinishedTriggersSet
implements FinishedTriggers {
    private final Set<ExecutableTriggerStateMachine> finishedTriggers;

    private FinishedTriggersSet(Set<ExecutableTriggerStateMachine> finishedTriggers) {
        this.finishedTriggers = finishedTriggers;
    }

    public static FinishedTriggersSet fromSet(Set<ExecutableTriggerStateMachine> finishedTriggers) {
        return new FinishedTriggersSet(finishedTriggers);
    }

    public Set<ExecutableTriggerStateMachine> getFinishedTriggers() {
        return this.finishedTriggers;
    }

    @Override
    public boolean isFinished(ExecutableTriggerStateMachine trigger) {
        return this.finishedTriggers.contains(trigger);
    }

    @Override
    public void setFinished(ExecutableTriggerStateMachine trigger, boolean value) {
        if (value) {
            this.finishedTriggers.add(trigger);
        } else {
            this.finishedTriggers.remove(trigger);
        }
    }

    @Override
    public void clearRecursively(ExecutableTriggerStateMachine trigger) {
        this.finishedTriggers.remove(trigger);
        for (ExecutableTriggerStateMachine subTrigger : trigger.subTriggers()) {
            this.clearRecursively(subTrigger);
        }
    }

    @Override
    public FinishedTriggersSet copy() {
        return FinishedTriggersSet.fromSet(Sets.newHashSet(this.finishedTriggers));
    }
}

