/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.metrics.LabeledMetrics;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class ServiceCallMetric {
    public static final Map<Integer, String> CANONICAL_STATUS_MAP = ImmutableMap.builder().put((Object)200, (Object)"ok").put((Object)400, (Object)"out_of_range").put((Object)401, (Object)"unauthenticated").put((Object)403, (Object)"permission_denied").put((Object)404, (Object)"not_found").put((Object)409, (Object)"already_exists").put((Object)429, (Object)"resource_exhausted").put((Object)499, (Object)"cancelled").put((Object)500, (Object)"internal").put((Object)501, (Object)"not_implemented").put((Object)503, (Object)"unavailable").put((Object)504, (Object)"deadline_exceeded").build();
    public static final String CANONICAL_STATUS_UNKNOWN = "unknown";
    public static final Map<String, String> STATUS_NORMALIZATION_MAP = ImmutableMap.builder().put((Object)"outofrange", (Object)"out_of_range").put((Object)"permissiondenied", (Object)"permission_denied").put((Object)"notfound", (Object)"not_found").put((Object)"alreadyexists", (Object)"already_exists").put((Object)"resourceexhausted", (Object)"resource_exhausted").put((Object)"notimplemented", (Object)"not_implemented").put((Object)"unavailable", (Object)"unavailable").put((Object)"deadlineexceeded", (Object)"deadline_exceeded").build();
    private HashMap<String, String> labels;
    private final String requestCountUrn;

    public ServiceCallMetric(String requestCountUrn, HashMap<String, String> baseLabels) {
        this.requestCountUrn = requestCountUrn;
        this.labels = baseLabels;
    }

    public void call(int httpStatusCode) {
        String canonicalStatusCode = ServiceCallMetric.convertToCanonicalStatusString(httpStatusCode);
        this.call(canonicalStatusCode);
    }

    public void call(String statusCode) {
        this.labels.put("STATUS", ServiceCallMetric.convertToCanonicalStatusString(statusCode));
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named(this.requestCountUrn, this.labels);
        Counter counter = LabeledMetrics.counter(name, true);
        counter.inc();
    }

    public static String convertToCanonicalStatusString(int httpStatusCode) {
        return CANONICAL_STATUS_MAP.getOrDefault(httpStatusCode, CANONICAL_STATUS_UNKNOWN);
    }

    public static String convertToCanonicalStatusString(String statusCode) {
        if (statusCode == null) {
            return CANONICAL_STATUS_UNKNOWN;
        }
        String normalizedStatus = STATUS_NORMALIZATION_MAP.get(statusCode.toLowerCase());
        if (normalizedStatus != null) {
            return normalizedStatus;
        }
        return statusCode.toLowerCase();
    }
}

