/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure.config;

import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.vfs.azure.config.AzureConfig;
import org.apache.hop.vfs.azure.config.AzureConfigSingleton;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="AzureConfigPlugin", description="Configuration options for Azure", category="config")
@GuiPlugin(description="Azure")
public class AzureConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_AZURE_ACCOUNT = "10000-azure-account";
    private static final String WIDGET_ID_AZURE_KEY = "10100-azure-key";
    private static final String WIDGET_ID_AZURE_BLOCK_INCREMENT = "10200-azure-block-increment";
    @GuiWidgetElement(id="10000-azure-account", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="Your Azure account")
    @CommandLine.Option(names={"-aza", "--azure-account"}, description={"The account to use for the Azure VFS"})
    private String account;
    @GuiWidgetElement(id="10100-azure-key", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, password=true, label="Your Azure key")
    @CommandLine.Option(names={"-azk", "--azure-key"}, description={"The key to use for the Azure VFS"})
    private String key;
    @GuiWidgetElement(id="10200-azure-block-increment", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="File block increment size (multiples of 512 only)")
    @CommandLine.Option(names={"-azi", "--azure-block-increment"}, description={"The block increment size for new files on Azure, multiples of 512 only."})
    private String blockIncrement;

    public static AzureConfigPlugin getInstance() {
        AzureConfigPlugin instance = new AzureConfigPlugin();
        AzureConfig config = AzureConfigSingleton.getConfig();
        instance.account = config.getAccount();
        instance.key = config.getKey();
        instance.blockIncrement = config.getBlockIncrement();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        AzureConfig config = AzureConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.account != null) {
                config.setAccount(this.account);
                log.logBasic("The Azure account is set to '" + this.account + "'");
                changed = true;
            }
            if (this.key != null) {
                config.setKey(this.key);
                log.logBasic("The Azure key is set to '" + this.key + "'");
                changed = true;
            }
            if (this.blockIncrement != null) {
                config.setBlockIncrement(this.blockIncrement);
                log.logBasic("The Azure file block increment is set to '" + this.blockIncrement + "'");
                changed = true;
            }
            if (changed) {
                AzureConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling Azure configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-azure-account": {
                    this.account = ((TextVar)control).getText();
                    AzureConfigSingleton.getConfig().setAccount(this.account);
                    break;
                }
                case "10100-azure-key": {
                    this.key = ((TextVar)control).getText();
                    AzureConfigSingleton.getConfig().setKey(this.key);
                    break;
                }
                case "10200-azure-block-increment": {
                    this.blockIncrement = ((TextVar)control).getText();
                    AzureConfigSingleton.getConfig().setKey(this.blockIncrement);
                }
            }
        }
        try {
            AzureConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setBlockIncrement(String blockIncrement) {
        this.blockIncrement = blockIncrement;
    }
}

