/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xslt;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xslt.XsltData;
import org.apache.hop.pipeline.transforms.xml.xslt.XsltMeta;

public class Xslt
extends BaseTransform<XsltMeta, XsltData> {
    private static final Class<?> PKG = XsltMeta.class;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public Xslt(TransformMeta transformMeta, XsltMeta meta, XsltData data, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, trans);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int nrOutputProps;
            this.first = false;
            ((XsltData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((XsltMeta)this.meta).getFields(((XsltData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (Utils.isEmpty((CharSequence)((XsltMeta)this.meta).getResultfieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorResultFieldMissing", (String[])new String[0]));
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorResultFieldMissing", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)((XsltMeta)this.meta).getFieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXMLFieldMissing", (String[])new String[0]));
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXMLFieldMissing", (String[])new String[0]));
            }
            ((XsltData)this.data).fieldposition = this.getInputRowMeta().indexOfValue(((XsltMeta)this.meta).getFieldname());
            if (((XsltData)this.data).fieldposition < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((XsltMeta)this.meta).getFieldname() + "]");
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.CouldnotFindField", (String[])new String[]{((XsltMeta)this.meta).getFieldname()}));
            }
            if (((XsltMeta)this.meta).useXSLField()) {
                if (Utils.isEmpty((CharSequence)((XsltMeta)this.meta).getXSLFileField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFileFieldMissing", (String[])new String[0]));
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFileFieldMissing", (String[])new String[0]));
                }
                ((XsltData)this.data).fielxslfiledposition = this.getInputRowMeta().indexOfValue(((XsltMeta)this.meta).getXSLFileField());
                if (((XsltData)this.data).fielxslfiledposition < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFileFieldFinding", (String[])new String[0]) + "[" + ((XsltMeta)this.meta).getXSLFileField() + "]");
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFileFieldFinding", (String[])new String[]{((XsltMeta)this.meta).getXSLFileField()}));
                }
            } else {
                if (Utils.isEmpty((CharSequence)((XsltMeta)this.meta).getXslFilename())) {
                    this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFile", (String[])new String[0]));
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFile", (String[])new String[0]));
                }
                ((XsltData)this.data).xslfilename = this.resolve(((XsltMeta)this.meta).getXslFilename());
                FileObject file = null;
                try {
                    file = HopVfs.getFileObject((String)((XsltData)this.data).xslfilename);
                    if (!file.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFileNotExists", (String[])new String[]{((XsltData)this.data).xslfilename}));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFileNotExists", (String[])new String[]{((XsltData)this.data).xslfilename}));
                    }
                    if (file.getType() != FileType.FILE) {
                        this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLNotAFile", (String[])new String[]{((XsltData)this.data).xslfilename}));
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLNotAFile", (String[])new String[]{((XsltData)this.data).xslfilename}));
                    }
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            int n = nrOutputProps = ((XsltMeta)this.meta).getOutputPropertyName() == null ? 0 : ((XsltMeta)this.meta).getOutputPropertyName().length;
            if (nrOutputProps > 0) {
                ((XsltData)this.data).outputProperties = new Properties();
                for (int i = 0; i < nrOutputProps; ++i) {
                    ((XsltData)this.data).outputProperties.put(((XsltMeta)this.meta).getOutputPropertyName()[i], this.resolve(((XsltMeta)this.meta).getOutputPropertyValue()[i]));
                }
                ((XsltData)this.data).setOutputProperties = true;
            }
            int n2 = ((XsltData)this.data).nrParams = ((XsltMeta)this.meta).getParameterField() == null ? 0 : ((XsltMeta)this.meta).getParameterField().length;
            if (((XsltData)this.data).nrParams > 0) {
                ((XsltData)this.data).indexOfParams = new int[((XsltData)this.data).nrParams];
                ((XsltData)this.data).nameOfParams = new String[((XsltData)this.data).nrParams];
                for (int i = 0; i < ((XsltData)this.data).nrParams; ++i) {
                    String name = this.resolve(((XsltMeta)this.meta).getParameterName()[i]);
                    String field = this.resolve(((XsltMeta)this.meta).getParameterField()[i]);
                    if (Utils.isEmpty((CharSequence)field)) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ParameterFieldMissing", (Object[])new Object[]{name, i}));
                    }
                    ((XsltData)this.data).indexOfParams[i] = this.getInputRowMeta().indexOfValue(field);
                    if (((XsltData)this.data).indexOfParams[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ParameterFieldNotFound", (String[])new String[]{name}));
                    }
                    ((XsltData)this.data).nameOfParams[i] = name;
                }
                ((XsltData)this.data).useParameters = true;
            }
            ((XsltData)this.data).factory = TransformerFactory.newInstance();
            if (((XsltMeta)this.meta).getXSLFactory().equals("SAXON")) {
                ((XsltData)this.data).factory = new TransformerFactoryImpl();
            }
        }
        String xmlValue = this.getInputRowMeta().getString(row, ((XsltData)this.data).fieldposition);
        if (((XsltMeta)this.meta).useXSLField()) {
            ((XsltData)this.data).xslfilename = this.getInputRowMeta().getString(row, ((XsltData)this.data).fielxslfiledposition);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.XslfileNameFromFied", (String[])new String[]{((XsltData)this.data).xslfilename, ((XsltMeta)this.meta).getXSLFileField()}));
            }
        }
        try {
            if (this.log.isDetailed()) {
                if (((XsltMeta)this.meta).isXSLFieldIsAFile()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.Filexsl", (String[])new String[0]) + ((XsltData)this.data).xslfilename);
                } else {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.XslStream", (String[])new String[]{((XsltData)this.data).xslfilename}));
                }
            }
            Transformer transformer = ((XsltData)this.data).getTemplate(((XsltData)this.data).xslfilename, ((XsltData)this.data).xslIsAfile);
            if (((XsltData)this.data).setOutputProperties) {
                transformer.setOutputProperties(((XsltData)this.data).outputProperties);
            }
            if (((XsltData)this.data).useParameters) {
                for (int i = 0; i < ((XsltData)this.data).nrParams; ++i) {
                    transformer.setParameter(((XsltData)this.data).nameOfParams[i], row[((XsltData)this.data).indexOfParams[i]]);
                }
            }
            StreamSource source = new StreamSource(new StringReader(xmlValue));
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.FileResult", (String[])new String[0]));
                this.logDetailed(xmlString);
            }
            Object[] outputRowData = RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)xmlString);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"Xslt.Log.ReadRow", (String[])new String[0]) + " " + this.getInputRowMeta().getString(row));
            }
            this.putRow(((XsltData)this.data).outputRowMeta, outputRowData);
        }
        catch (Exception e) {
            String errorMessage = e.getClass().toString() + ": " + e.getMessage();
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, ((XsltMeta)this.meta).getResultfieldname(), "XSLT01");
            }
            this.logError(BaseMessages.getString(PKG, (String)("Xslt.ErrorProcesing : " + errorMessage), (String[])new String[0]), e);
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"Xslt.ErrorProcesing", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((XsltData)this.data).xslIsAfile = ((XsltMeta)this.meta).useXSLField() && ((XsltMeta)this.meta).isXSLFieldIsAFile() || !((XsltMeta)this.meta).useXSLField();
            return true;
        }
        return false;
    }

    public void dispose() {
        ((XsltData)this.data).dispose();
        super.dispose();
    }
}

