/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public abstract class LazyBinaryNonPrimitive<OI extends ObjectInspector>
extends LazyBinaryObject<OI> {
    protected ByteArrayRef bytes = null;
    protected int start = 0;
    protected int length = 0;

    protected LazyBinaryNonPrimitive(OI oi) {
        super(oi);
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (null == bytes) {
            throw new RuntimeException("bytes cannot be null!");
        }
        if (length < 0) {
            throw new RuntimeException("length should be non-negative!");
        }
        this.bytes = bytes;
        this.start = start;
        this.length = length;
    }

    @Override
    public int hashCode() {
        return LazyUtils.hashBytes(this.bytes.getData(), this.start, this.length);
    }
}

