/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.SingleInputOutputOverrideFactory;
import org.apache.beam.runners.dataflow.CreateDataflowView;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;

class StreamingViewOverrides {
    StreamingViewOverrides() {
    }

    private static class Concatenate<T>
    extends Combine.CombineFn<T, List<T>, List<T>> {
        private Concatenate() {
        }

        public List<T> createAccumulator() {
            return new ArrayList();
        }

        public List<T> addInput(List<T> accumulator, T input) {
            accumulator.add(input);
            return accumulator;
        }

        public List<T> mergeAccumulators(Iterable<List<T>> accumulators) {
            Object result = this.createAccumulator();
            for (List<T> accumulator : accumulators) {
                result.addAll(accumulator);
            }
            return result;
        }

        public List<T> extractOutput(List<T> accumulator) {
            return accumulator;
        }

        public Coder<List<T>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return ListCoder.of(inputCoder);
        }

        public Coder<List<T>> getDefaultOutputCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return ListCoder.of(inputCoder);
        }
    }

    static class StreamingCreatePCollectionViewFactory<ElemT, ViewT>
    extends SingleInputOutputOverrideFactory<PCollection<ElemT>, PCollection<ElemT>, View.CreatePCollectionView<ElemT, ViewT>> {
        StreamingCreatePCollectionViewFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<ElemT>, PCollection<ElemT>> getReplacementTransform(AppliedPTransform<PCollection<ElemT>, PCollection<ElemT>, View.CreatePCollectionView<ElemT, ViewT>> transform) {
            StreamingCreatePCollectionView streamingView = new StreamingCreatePCollectionView(((View.CreatePCollectionView)transform.getTransform()).getView());
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), streamingView);
        }

        private static class StreamingCreatePCollectionView<ElemT, ViewT>
        extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
            private final PCollectionView<ViewT> view;

            private StreamingCreatePCollectionView(PCollectionView<ViewT> view) {
                this.view = view;
            }

            public PCollection<ElemT> expand(PCollection<ElemT> input) {
                return (PCollection)((PCollection)((PCollection)input.apply((PTransform)Combine.globally(new Concatenate()).withoutDefaults())).apply((PTransform)ParDo.of(DataflowRunner.StreamingPCollectionViewWriterFn.create(this.view, input.getCoder())))).apply(CreateDataflowView.forStreaming(this.view));
            }
        }
    }
}

