/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.ArrayDeque;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

class DataflowPTransformMatchers {
    private DataflowPTransformMatchers() {
    }

    static class CombineValuesWithParentCheckPTransformMatcher
    implements PTransformMatcher {
        CombineValuesWithParentCheckPTransformMatcher() {
        }

        public boolean matches(AppliedPTransform<?, ?, ?> application) {
            return application.getTransform().getClass().equals(Combine.GroupedValues.class) && ((Combine.GroupedValues)application.getTransform()).getSideInputs().isEmpty() && this.parentIsCombinePerKey(application);
        }

        private boolean parentIsCombinePerKey(final AppliedPTransform<?, ?, ?> application) {
            AppliedPTransform appliedParent;
            final TransformHierarchy.Node[] parent = new TransformHierarchy.Node[1];
            Pipeline pipeline = application.getPipeline();
            pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){
                private ArrayDeque<TransformHierarchy.Node> parents = new ArrayDeque();

                public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                    Pipeline.PipelineVisitor.CompositeBehavior behavior = Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
                    if (!node.isRootNode() && node.toAppliedPTransform(this.getPipeline()).equals(application)) {
                        parent[0] = this.parents.isEmpty() ? null : this.parents.peekFirst();
                        behavior = Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
                    }
                    this.parents.addFirst(node);
                    return behavior;
                }

                public void leaveCompositeTransform(TransformHierarchy.Node node) {
                    if (!node.isRootNode()) {
                        this.parents.removeFirst();
                    }
                }
            });
            if (parent[0] == null) {
                return false;
            }
            try {
                appliedParent = parent[0].toAppliedPTransform(pipeline);
            }
            catch (NullPointerException e) {
                return false;
            }
            return appliedParent.getTransform().getClass().equals(Combine.PerKey.class);
        }

        public String toString() {
            return MoreObjects.toStringHelper(CombineValuesWithParentCheckPTransformMatcher.class).toString();
        }
    }

    static class CombineValuesWithoutSideInputsPTransformMatcher
    implements PTransformMatcher {
        CombineValuesWithoutSideInputsPTransformMatcher() {
        }

        public boolean matches(AppliedPTransform<?, ?, ?> application) {
            return application.getTransform().getClass().equals(Combine.GroupedValues.class) && ((Combine.GroupedValues)application.getTransform()).getSideInputs().isEmpty();
        }

        public String toString() {
            return MoreObjects.toStringHelper(CombineValuesWithoutSideInputsPTransformMatcher.class).toString();
        }
    }
}

