/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class OsHelper {
    public static final String WS_WIN32 = "win32";
    public static final String WS_MOTIF = "motif";
    public static final String WS_GTK = "gtk";
    public static final String WS_PHOTON = "photon";
    public static final String WS_CARBON = "carbon";
    public static final String WS_COCOA = "cocoa";
    public static final String WS_WPF = "wpf";
    public static final String WS_UNKNOWN = "unknown";

    public static final boolean isWindows() {
        String ws = SWT.getPlatform();
        return WS_WIN32.equals(ws) || WS_WPF.equals(ws);
    }

    public static final boolean isMac() {
        String ws = SWT.getPlatform();
        return WS_CARBON.equals(ws) || WS_COCOA.equals(ws);
    }

    public static String customizeMenuitemText(String txt) {
        if (!OsHelper.isMac()) {
            return txt;
        }
        String[] parts = txt.split("\t");
        if (parts.length <= 1) {
            return txt;
        }
        ArrayList<String> items = new ArrayList<String>();
        items.addAll(Arrays.asList(parts));
        String key = (String)items.remove(items.size() - 1);
        key = key.toUpperCase().replaceAll("CTRL", "\u2318");
        key = key.toUpperCase().replaceAll("SHIFT", "\u21e7");
        key = key.toUpperCase().replaceAll("ALT", "\u2325");
        key = key.toUpperCase().replaceAll("ESC", "\u238b");
        key = key.toUpperCase().replaceAll("DEL", "\u2326");
        key = key.toUpperCase().replaceAll("UP", "\u2191");
        key = key.toUpperCase().replaceAll("DOWN", "\u2193");
        key = key.toUpperCase().replaceAll("LEFT", "\u2190");
        key = key.toUpperCase().replaceAll("RIGHT", "\u2192");
        key = key.replaceAll("-", "");
        key = key.replaceAll("\\+", "");
        String result = StringUtils.join(items, (String)"\t") + "\t " + key;
        return result;
    }

    public static boolean setAppName() {
        if (OsHelper.isMac()) {
            String appName = "Hop";
            Display.setAppName((String)appName);
        }
        return true;
    }

    public static void initOsHandlers(Display display) {
        display.addListener(46, event -> HopGui.getInstance().fileDelegate.fileOpen());
        display.addListener(21, event -> {
            try {
                HopGui.getInstance().menuFileExit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (OsHelper.isMac()) {
            MenuItem[] items;
            Menu m = display.getSystemMenu();
            block4: for (MenuItem item : items = m.getItems()) {
                switch (item.getID()) {
                    case -1: {
                        item.addListener(13, event -> HopGui.getInstance().menuHelpAbout());
                        continue block4;
                    }
                    case -2: {
                        item.addListener(13, event -> HopGui.getConfigurationPerspective().activate());
                        continue block4;
                    }
                }
            }
        }
    }
}

