/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.sql.DriverPropertyInfo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JdbcConfig {
    private static final Logger log = LoggerFactory.getLogger(JdbcConfig.class);
    public static final String PROP_AUTO_COMMIT = "autoCommit";
    public static final String PROP_CREATE_DATABASE = "createDatabaseIfNotExist";
    public static final String PROP_CONTINUE_BATCH = "continueBatchOnError";
    public static final String PROP_FETCH_SIZE = "fetchSize";
    public static final String PROP_JDBC_COMPLIANT = "jdbcCompliant";
    public static final String PROP_NAMED_PARAM = "namedParameter";
    public static final String PROP_NULL_AS_DEFAULT = "nullAsDefault";
    public static final String PROP_TX_SUPPORT = "transactionSupport";
    public static final String PROP_TYPE_MAP = "typeMappings";
    public static final String PROP_WRAPPER_OBJ = "wrapperObject";
    private static final String BOOLEAN_FALSE = "false";
    private static final String BOOLEAN_TRUE = "true";
    private static final String DEFAULT_AUTO_COMMIT = "true";
    private static final String DEFAULT_CREATE_DATABASE = "false";
    private static final String DEFAULT_CONTINUE_BATCH = "false";
    private static final String DEFAULT_FETCH_SIZE = "0";
    private static final String DEFAULT_JDBC_COMPLIANT = "true";
    private static final String DEFAULT_NAMED_PARAM = "false";
    private static final String DEFAULT_NULL_AS_DEFAULT = "0";
    private static final String DEFAULT_TX_SUPPORT = "false";
    private static final String DEFAULT_TYPE_MAP = "";
    private static final String DEFAULT_WRAPPER_OBJ = "false";
    private final boolean autoCommit;
    private final boolean createDb;
    private final boolean continueBatch;
    private final int fetchSize;
    private final boolean jdbcCompliant;
    private final boolean namedParameter;
    private final int nullAsDefault;
    private final boolean txSupport;
    private final Map<String, Class<?>> typeMap;
    private final boolean wrapperObject;

    static boolean extractBooleanValue(Properties props, String key, String defaultValue) {
        if (props == null || props.isEmpty() || key == null || key.isEmpty()) {
            return Boolean.parseBoolean(defaultValue);
        }
        Object value = props.remove(key);
        return Boolean.parseBoolean(value != null ? value.toString() : defaultValue);
    }

    static int extractIntValue(Properties props, String key, String defaultValue) {
        if (props == null || props.isEmpty() || key == null || key.isEmpty()) {
            return Integer.parseInt(defaultValue);
        }
        Object value = props.remove(key);
        return Integer.parseInt(value != null ? value.toString() : defaultValue);
    }

    static Map<String, Class<?>> extractTypeMapValue(Properties props, String key, String defaultValue) {
        String value = null;
        if (props == null || props.isEmpty() || key == null || key.isEmpty()) {
            value = defaultValue;
        } else {
            Object v = props.remove(key);
            String string = value = v != null ? v.toString() : defaultValue;
        }
        if (ClickHouseChecker.isNullOrBlank(value)) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = new LinkedHashMap();
        ClassLoader loader = JdbcConfig.class.getClassLoader();
        for (Map.Entry<String, String> e : ClickHouseUtils.getKeyValuePairs(value).entrySet()) {
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(e.getValue());
            }
            catch (Throwable t) {
                log.warn((Object)"Failed to add mapping [%s]=[%s], due to: %s", e.getKey(), e.getValue(), t.getMessage());
            }
            if (clazz == null) continue;
            map.put(e.getKey(), clazz);
        }
        return Collections.unmodifiableMap(map);
    }

    public static List<DriverPropertyInfo> getDriverProperties() {
        LinkedList<DriverPropertyInfo> list = new LinkedList<DriverPropertyInfo>();
        DriverPropertyInfo info = new DriverPropertyInfo(PROP_AUTO_COMMIT, "true");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to enable auto commit when connection is created.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_CREATE_DATABASE, "false");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to automatically create database when it does not exist.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_CONTINUE_BATCH, "false");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to continue batch process when error occurred.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_FETCH_SIZE, "0");
        info.description = "Default fetch size, negative or zero means no preferred option.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_JDBC_COMPLIANT, "true");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to enable JDBC-compliant features like fake transaction and standard UPDATE and DELETE statements.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_NAMED_PARAM, "false");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to use named parameter(e.g. :ts(DateTime64(6)) or :value etc.) instead of standard JDBC question mark placeholder.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_NULL_AS_DEFAULT, "0");
        info.description = "Default approach to handle null value, sets to 0 or negative number to throw exception when target column is not nullable, 1 to disable the null-check, and 2 or higher to replace null to default value of corresponding data type.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_TX_SUPPORT, "false");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to enable transaction support or not.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_TYPE_MAP, DEFAULT_TYPE_MAP);
        info.description = "Default type mappings between ClickHouse data type and Java class. You can define multiple mappings using comma as separator.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_WRAPPER_OBJ, "false");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to return wrapper object like Array or Struct in ResultSet.getObject method.";
        list.add(info);
        return Collections.unmodifiableList(list);
    }

    public JdbcConfig() {
        this(null);
    }

    public JdbcConfig(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.autoCommit = JdbcConfig.extractBooleanValue(props, PROP_AUTO_COMMIT, "true");
        this.createDb = JdbcConfig.extractBooleanValue(props, PROP_CREATE_DATABASE, "false");
        this.continueBatch = JdbcConfig.extractBooleanValue(props, PROP_CONTINUE_BATCH, "false");
        this.fetchSize = JdbcConfig.extractIntValue(props, PROP_FETCH_SIZE, "0");
        this.jdbcCompliant = JdbcConfig.extractBooleanValue(props, PROP_JDBC_COMPLIANT, "true");
        this.namedParameter = JdbcConfig.extractBooleanValue(props, PROP_NAMED_PARAM, "false");
        this.nullAsDefault = JdbcConfig.extractIntValue(props, PROP_NULL_AS_DEFAULT, "0");
        this.txSupport = JdbcConfig.extractBooleanValue(props, PROP_TX_SUPPORT, "false");
        this.typeMap = JdbcConfig.extractTypeMapValue(props, PROP_TYPE_MAP, DEFAULT_TYPE_MAP);
        this.wrapperObject = JdbcConfig.extractBooleanValue(props, PROP_WRAPPER_OBJ, "false");
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isCreateDbIfNotExist() {
        return this.createDb;
    }

    public boolean isContinueBatchOnError() {
        return this.continueBatch;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public boolean isTransactionSupported() {
        return this.txSupport;
    }

    public int getNullAsDefault() {
        return this.nullAsDefault;
    }

    public boolean useNamedParameter() {
        return this.namedParameter;
    }

    public boolean useWrapperObject() {
        return this.wrapperObject;
    }
}

