/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseEnum;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseEnumValue
implements ClickHouseValue {
    private final ClickHouseEnum type;
    private boolean isNull;
    private int value;

    public static ClickHouseEnumValue ofNull(Class<? extends Enum> clazz) {
        return ClickHouseEnumValue.ofNull(null, ClickHouseEnum.of(clazz));
    }

    public static ClickHouseEnumValue ofNull(ClickHouseEnum type) {
        return ClickHouseEnumValue.ofNull(null, type);
    }

    public static ClickHouseEnumValue ofNull(ClickHouseValue ref, Class<? extends Enum> clazz) {
        return ref instanceof ClickHouseEnumValue ? ((ClickHouseEnumValue)ref).set(true, 0) : new ClickHouseEnumValue(ClickHouseEnum.of(clazz), true, 0);
    }

    public static ClickHouseEnumValue ofNull(ClickHouseValue ref, ClickHouseEnum type) {
        return ref instanceof ClickHouseEnumValue ? ((ClickHouseEnumValue)ref).set(true, 0) : new ClickHouseEnumValue(type, true, 0);
    }

    public static ClickHouseEnumValue of(Enum<?> value) {
        return ClickHouseEnumValue.of(null, value);
    }

    public static ClickHouseEnumValue of(ClickHouseEnum type, int value) {
        return ClickHouseEnumValue.of(null, type, value);
    }

    public static ClickHouseEnumValue of(ClickHouseEnum type, Number value) {
        return value == null ? ClickHouseEnumValue.ofNull(null, type) : ClickHouseEnumValue.of(null, type, value.intValue());
    }

    public static ClickHouseEnumValue of(ClickHouseValue ref, Enum<?> value) {
        ClickHouseEnumValue v;
        if (ref instanceof ClickHouseEnumValue) {
            v = (ClickHouseEnumValue)ref;
            if (value != null) {
                v.set(false, value.ordinal());
            } else {
                v.resetToNullOrEmpty();
            }
        } else {
            v = value != null ? new ClickHouseEnumValue(ClickHouseEnum.of(value.getClass()), false, value.ordinal()) : new ClickHouseEnumValue(ClickHouseEnum.EMPTY, true, 0);
        }
        return v;
    }

    public static ClickHouseEnumValue of(ClickHouseValue ref, ClickHouseEnum type, int value) {
        return ref instanceof ClickHouseEnumValue ? ((ClickHouseEnumValue)ref).set(false, value) : new ClickHouseEnumValue(type, false, value);
    }

    protected ClickHouseEnumValue(ClickHouseEnum type, boolean isNull, int value) {
        this.type = type != null ? type : ClickHouseEnum.EMPTY;
        this.set(isNull, value);
    }

    protected ClickHouseEnumValue set(boolean isNull, int value) {
        this.isNull = isNull;
        this.value = isNull ? 0 : this.type.validate(value);
        return this;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public ClickHouseEnumValue copy(boolean deep) {
        return new ClickHouseEnumValue(this.type, this.isNull, this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInteger() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNull ? null : BigDecimal.valueOf(this.value, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : this.type.name(this.value);
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNull) {
            return null;
        }
        String str = this.type.name(this.value);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseEnumValue resetToDefault() {
        return this.set(false, 0);
    }

    @Override
    public ClickHouseEnumValue resetToNullOrEmpty() {
        return this.set(true, 0);
    }

    @Override
    public String toSqlExpression() {
        return this.isNull ? "NULL" : Integer.toString(this.value);
    }

    @Override
    public ClickHouseEnumValue update(char value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseEnumValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseEnumValue update(short value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseEnumValue update(int value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseEnumValue update(long value) {
        return this.set(false, (int)value);
    }

    @Override
    public ClickHouseEnumValue update(float value) {
        return this.set(false, (int)value);
    }

    @Override
    public ClickHouseEnumValue update(double value) {
        return this.set(false, (int)value);
    }

    @Override
    public ClickHouseEnumValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.intValueExact());
    }

    @Override
    public ClickHouseEnumValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.intValueExact());
    }

    @Override
    public ClickHouseEnumValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.ordinal());
    }

    @Override
    public ClickHouseEnumValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, this.type.value(value));
    }

    @Override
    public ClickHouseEnumValue update(ClickHouseValue value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.asInteger());
    }

    @Override
    public ClickHouseEnumValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).intValue());
        }
        if (value instanceof String) {
            return this.set(false, this.type.value((String)value));
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asInteger());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseEnumValue v = (ClickHouseEnumValue)obj;
        return this.isNull == v.isNull && this.value == v.value && this.type.equals(v.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.isNull ? 1231 : 1237);
        result = 31 * result + this.value;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

