/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ClickHouseNodeSelector
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseNodeSelector.class);
    private static final long serialVersionUID = 488571984297086418L;
    public static final ClickHouseNodeSelector EMPTY = new ClickHouseNodeSelector(Collections.emptyList(), Collections.emptyList());
    private final List<ClickHouseProtocol> protocols;
    private final Set<String> tags;

    public static ClickHouseNodeSelector of(ClickHouseProtocol protocol, ClickHouseProtocol ... more) {
        LinkedList<ClickHouseProtocol> list = new LinkedList<ClickHouseProtocol>();
        if (protocol != null) {
            list.add(protocol);
        }
        if (more != null) {
            for (ClickHouseProtocol p : more) {
                if (p == null) continue;
                list.add(p);
            }
        }
        return ClickHouseNodeSelector.of(list, null);
    }

    public static ClickHouseNodeSelector of(String tag, String ... more) {
        LinkedList<String> list = new LinkedList<String>();
        if (!ClickHouseChecker.isNullOrEmpty(tag)) {
            list.add(tag);
        }
        if (more != null) {
            for (String t : more) {
                if (ClickHouseChecker.isNullOrEmpty(t)) continue;
                list.add(t);
            }
        }
        return ClickHouseNodeSelector.of(null, list);
    }

    public static ClickHouseNodeSelector of(Collection<ClickHouseProtocol> protocols, Collection<String> tags) {
        return !(protocols != null && !protocols.isEmpty() || tags != null && !tags.isEmpty()) ? EMPTY : new ClickHouseNodeSelector(protocols, tags);
    }

    protected ClickHouseNodeSelector(Collection<ClickHouseProtocol> protocols, Collection<String> tags) {
        if (protocols == null || protocols.isEmpty()) {
            this.protocols = Collections.emptyList();
        } else {
            ArrayList<ClickHouseProtocol> p = new ArrayList<ClickHouseProtocol>(protocols.size());
            for (ClickHouseProtocol protocol : protocols) {
                if (protocol == ClickHouseProtocol.ANY) {
                    p.clear();
                    break;
                }
                if (protocol == null || p.contains((Object)protocol)) continue;
                p.add(protocol);
            }
            List<Object> list = this.protocols = p.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(p);
        }
        if (tags == null || tags.isEmpty()) {
            this.tags = Collections.emptySet();
        } else {
            HashSet<String> t = new HashSet<String>();
            for (String tag : tags) {
                if (tag == null || (tag = tag.trim()).isEmpty()) continue;
                t.add(tag);
            }
            this.tags = t.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(t);
        }
    }

    public List<ClickHouseProtocol> getPreferredProtocols() {
        return this.protocols;
    }

    public Set<String> getPreferredTags() {
        return this.tags;
    }

    public boolean match(ClickHouseClient client) {
        boolean matched = false;
        if (client != null) {
            for (ClickHouseProtocol p : this.protocols) {
                log.debug((Object)"Checking [%s] against [%s]...", new Object[]{client, p});
                if (!client.accept(p)) continue;
                matched = true;
                break;
            }
        }
        return matched;
    }

    public boolean match(ClickHouseNode node) {
        boolean matched = false;
        if (node != null) {
            matched = this.matchAnyOfPreferredProtocols(node.getProtocol()) && this.matchAllPreferredTags(node.getTags());
        }
        return matched;
    }

    public boolean matchAnyOfPreferredProtocols(ClickHouseProtocol protocol) {
        boolean matched;
        boolean bl = matched = this.protocols.isEmpty() || protocol == ClickHouseProtocol.ANY;
        if (!matched && protocol != null) {
            for (ClickHouseProtocol p : this.protocols) {
                if (p != protocol) continue;
                matched = true;
                break;
            }
        }
        return matched;
    }

    public boolean matchAllPreferredTags(Collection<String> tags) {
        if (this.tags.isEmpty() || tags == null) {
            return tags == null || tags.isEmpty();
        }
        return this.tags.containsAll(tags);
    }

    public boolean matchAnyOfPreferredTags(Collection<String> tags) {
        boolean matched;
        boolean bl = matched = tags == null || tags.isEmpty();
        if (!matched) {
            for (String t : tags) {
                if (!this.tags.contains(t)) continue;
                matched = true;
                break;
            }
        }
        return matched;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.protocols.hashCode();
        result = 31 * result + this.tags.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseNodeSelector other = (ClickHouseNodeSelector)obj;
        return this.protocols.equals(other.protocols) && this.tags.equals(other.tags);
    }

    public String toString() {
        return "ClickHouseNodeSelector [protocols=" + this.protocols + ", tags=" + this.tags + ']';
    }
}

