/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.gaxx.retrying.NonCancellableFuture;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.rpc.Status;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class MutateRowsAttemptCallable
implements Callable<Void> {
    private static final StatusCode LOCAL_UNKNOWN_STATUS = new StatusCode(){

        public StatusCode.Code getCode() {
            return StatusCode.Code.UNKNOWN;
        }

        public Object getTransportCode() {
            return null;
        }
    };
    @Nonnull
    private final UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable;
    @Nonnull
    private final ApiCallContext callContext;
    @Nonnull
    private MutateRowsRequest currentRequest;
    @Nullable
    private List<Integer> originalIndexes;
    @Nonnull
    private final Set<StatusCode.Code> retryableCodes;
    @Nullable
    private final List<MutateRowsException.FailedMutation> permanentFailures;
    private RetryingFuture<Void> externalFuture;
    private final ApiFunction<List<MutateRowsResponse>, Void> attemptSuccessfulCallback = new ApiFunction<List<MutateRowsResponse>, Void>(){

        public Void apply(List<MutateRowsResponse> responses) {
            MutateRowsAttemptCallable.this.handleAttemptSuccess(responses);
            return null;
        }
    };
    private final ApiFunction<Throwable, List<MutateRowsResponse>> attemptFailedCallback = new ApiFunction<Throwable, List<MutateRowsResponse>>(){

        public List<MutateRowsResponse> apply(Throwable throwable) {
            MutateRowsAttemptCallable.this.handleAttemptError(throwable);
            return null;
        }
    };

    MutateRowsAttemptCallable(@Nonnull UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable, @Nonnull MutateRowsRequest originalRequest, @Nonnull ApiCallContext callContext, @Nonnull Set<StatusCode.Code> retryableCodes) {
        this.innerCallable = (UnaryCallable)Preconditions.checkNotNull(innerCallable, (Object)"innerCallable");
        this.currentRequest = (MutateRowsRequest)Preconditions.checkNotNull((Object)originalRequest, (Object)"currentRequest");
        this.callContext = (ApiCallContext)Preconditions.checkNotNull((Object)callContext, (Object)"callContext");
        this.retryableCodes = (Set)Preconditions.checkNotNull(retryableCodes, (Object)"retryableCodes");
        this.permanentFailures = Lists.newArrayList();
    }

    public void setExternalFuture(RetryingFuture<Void> externalFuture) {
        this.externalFuture = externalFuture;
    }

    @Override
    public Void call() {
        try {
            Preconditions.checkNotNull(this.externalFuture, (Object)"External future must be set before starting an attempt");
            this.callContext.getTracer().attemptStarted(this.externalFuture.getAttemptSettings().getOverallAttemptCount());
            Preconditions.checkState((this.currentRequest.getEntriesCount() > 0 ? 1 : 0) != 0, (Object)"Request doesn't have any mutations to send");
            ApiCallContext currentCallContext = this.callContext;
            if (currentCallContext.getTimeout() == null && !this.externalFuture.getAttemptSettings().getRpcTimeout().isZero()) {
                currentCallContext = currentCallContext.withTimeout(this.externalFuture.getAttemptSettings().getRpcTimeout());
            }
            this.externalFuture.setAttemptFuture(new NonCancellableFuture());
            if (this.externalFuture.isDone()) {
                return null;
            }
            ApiFuture innerFuture = this.innerCallable.futureCall((Object)this.currentRequest, currentCallContext);
            ApiFuture catching = ApiFutures.catching((ApiFuture)innerFuture, Throwable.class, this.attemptFailedCallback, (Executor)MoreExecutors.directExecutor());
            ApiFuture transformed = ApiFutures.transform((ApiFuture)catching, this.attemptSuccessfulCallback, (Executor)MoreExecutors.directExecutor());
            this.externalFuture.setAttemptFuture(transformed);
        }
        catch (Throwable e) {
            this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture((Throwable)e));
        }
        return null;
    }

    private void handleAttemptError(Throwable rpcError) {
        ApiException entryError = MutateRowsAttemptCallable.createSyntheticErrorForRpcFailure(rpcError);
        ImmutableList.Builder allFailures = ImmutableList.builder();
        MutateRowsRequest lastRequest = this.currentRequest;
        allFailures.addAll(this.permanentFailures);
        MutateRowsRequest.Builder builder = lastRequest.toBuilder().clearEntries();
        ArrayList newOriginalIndexes = Lists.newArrayList();
        for (int i = 0; i < this.currentRequest.getEntriesCount(); ++i) {
            int origIndex = this.getOriginalIndex(i);
            MutateRowsException.FailedMutation failedMutation = MutateRowsException.FailedMutation.create(origIndex, entryError);
            allFailures.add((Object)failedMutation);
            if (!failedMutation.getError().isRetryable()) {
                this.permanentFailures.add(failedMutation);
                continue;
            }
            newOriginalIndexes.add(origIndex);
            builder.addEntries(lastRequest.getEntries(i));
        }
        this.currentRequest = builder.build();
        this.originalIndexes = newOriginalIndexes;
        throw new MutateRowsException(rpcError, (List<MutateRowsException.FailedMutation>)allFailures.build(), entryError.isRetryable());
    }

    private void handleAttemptSuccess(List<MutateRowsResponse> responses) {
        ArrayList allFailures = Lists.newArrayList(this.permanentFailures);
        MutateRowsRequest lastRequest = this.currentRequest;
        MutateRowsRequest.Builder builder = lastRequest.toBuilder().clearEntries();
        ArrayList newOriginalIndexes = Lists.newArrayList();
        for (MutateRowsResponse response : responses) {
            for (MutateRowsResponse.Entry entry : response.getEntriesList()) {
                if (entry.getStatus().getCode() == 0) continue;
                int origIndex = this.getOriginalIndex((int)entry.getIndex());
                MutateRowsException.FailedMutation failedMutation = MutateRowsException.FailedMutation.create(origIndex, this.createEntryError(entry.getStatus()));
                allFailures.add(failedMutation);
                if (!failedMutation.getError().isRetryable()) {
                    this.permanentFailures.add(failedMutation);
                    continue;
                }
                newOriginalIndexes.add(origIndex);
                builder.addEntries(lastRequest.getEntries((int)entry.getIndex()));
            }
        }
        this.currentRequest = builder.build();
        this.originalIndexes = newOriginalIndexes;
        if (!allFailures.isEmpty()) {
            boolean isRetryable = builder.getEntriesCount() > 0;
            throw new MutateRowsException(null, allFailures, isRetryable);
        }
    }

    private int getOriginalIndex(int index) {
        return this.originalIndexes != null ? this.originalIndexes.get(index) : index;
    }

    private ApiException createEntryError(Status protoStatus) {
        io.grpc.Status grpcStatus = io.grpc.Status.fromCodeValue((int)protoStatus.getCode()).withDescription(protoStatus.getMessage());
        GrpcStatusCode gaxStatusCode = GrpcStatusCode.of((Status.Code)grpcStatus.getCode());
        return ApiExceptionFactory.createException((Throwable)grpcStatus.asRuntimeException(), (StatusCode)gaxStatusCode, (boolean)this.retryableCodes.contains(gaxStatusCode.getCode()));
    }

    private static ApiException createSyntheticErrorForRpcFailure(Throwable overallRequestError) {
        if (overallRequestError instanceof ApiException) {
            ApiException requestApiException = (ApiException)overallRequestError;
            return ApiExceptionFactory.createException((String)"Didn't receive a result for this mutation entry", (Throwable)overallRequestError, (StatusCode)requestApiException.getStatusCode(), (boolean)requestApiException.isRetryable());
        }
        return ApiExceptionFactory.createException((String)"Didn't receive a result for this mutation entry", (Throwable)overallRequestError, (StatusCode)LOCAL_UNKNOWN_STATUS, (boolean)false);
    }
}

