/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.bigtable.v2.ResponseParams;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Metadata;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@InternalApi
public class BigtableTracerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;

    public BigtableTracerStreamingCallable(@Nonnull ServerStreamingCallable<RequestT, ResponseT> callable) {
        this.innerCallable = (ServerStreamingCallable)Preconditions.checkNotNull(callable, (Object)"Inner callable must be set");
    }

    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
        if (context.getTracer() instanceof BigtableTracer) {
            BigtableTracerResponseObserver<ResponseT> innerObserver = new BigtableTracerResponseObserver<ResponseT>(responseObserver, (BigtableTracer)context.getTracer(), responseMetadata);
            this.innerCallable.call(request, innerObserver, (ApiCallContext)responseMetadata.addHandlers(context));
        } else {
            this.innerCallable.call(request, responseObserver, context);
        }
    }

    private class TracedStreamController
    implements StreamController {
        private final StreamController innerController;
        private final BigtableTracer tracer;

        TracedStreamController(StreamController innerController, BigtableTracer tracer) {
            this.innerController = innerController;
            this.tracer = tracer;
        }

        public void cancel() {
            this.innerController.cancel();
        }

        public void disableAutoInboundFlowControl() {
            this.tracer.disableFlowControl();
            this.innerController.disableAutoInboundFlowControl();
        }

        public void request(int i) {
            this.tracer.onRequest(i);
            this.innerController.request(i);
        }
    }

    private class BigtableTracerResponseObserver<ResponseT>
    implements ResponseObserver<ResponseT> {
        private final BigtableTracer tracer;
        private final ResponseObserver<ResponseT> outerObserver;
        private final GrpcResponseMetadata responseMetadata;

        BigtableTracerResponseObserver(ResponseObserver<ResponseT> observer, BigtableTracer tracer, GrpcResponseMetadata metadata) {
            this.tracer = tracer;
            this.outerObserver = observer;
            this.responseMetadata = metadata;
        }

        public void onStart(StreamController controller) {
            TracedStreamController tracedController = new TracedStreamController(controller, this.tracer);
            this.outerObserver.onStart((StreamController)tracedController);
        }

        public void onResponse(ResponseT response) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.outerObserver.onResponse(response);
            this.tracer.afterResponse(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }

        public void onError(Throwable t) {
            Metadata metadata = this.responseMetadata.getMetadata();
            Long latency = Util.getGfeLatency(metadata);
            this.tracer.recordGfeMetadata(latency, t);
            try {
                if (metadata != null) {
                    Metadata trailingMetadata;
                    byte[] trailers = (byte[])metadata.get(Util.METADATA_KEY);
                    if (trailers == null && (trailingMetadata = this.responseMetadata.getTrailingMetadata()) != null) {
                        trailers = (byte[])trailingMetadata.get(Util.METADATA_KEY);
                    }
                    if (trailers != null) {
                        ResponseParams decodedTrailers = ResponseParams.parseFrom((byte[])trailers);
                        this.tracer.setLocations(decodedTrailers.getZoneId(), decodedTrailers.getClusterId());
                    }
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
            this.outerObserver.onError(t);
        }

        public void onComplete() {
            Metadata metadata = this.responseMetadata.getMetadata();
            Long latency = Util.getGfeLatency(metadata);
            this.tracer.recordGfeMetadata(latency, null);
            try {
                if (metadata != null) {
                    Metadata trailingMetadata;
                    byte[] trailers = (byte[])metadata.get(Util.METADATA_KEY);
                    if (trailers == null && (trailingMetadata = this.responseMetadata.getTrailingMetadata()) != null) {
                        trailers = (byte[])trailingMetadata.get(Util.METADATA_KEY);
                    }
                    if (trailers != null) {
                        ResponseParams decodedTrailers = ResponseParams.parseFrom((byte[])trailers);
                        this.tracer.setLocations(decodedTrailers.getZoneId(), decodedTrailers.getClusterId());
                    }
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
            this.outerObserver.onComplete();
        }
    }
}

