/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.internal.AutoValue_RowSetUtil_Split;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.protobuf.ByteString;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public final class RowSetUtil {
    private RowSetUtil() {
    }

    @Nonnull
    public static Split split(@Nonnull RowSet rowSet, @Nonnull ByteString splitPoint) {
        if (splitPoint.isEmpty()) {
            return Split.of(null, rowSet);
        }
        if (rowSet.getRowKeysList().isEmpty() && rowSet.getRowRangesList().isEmpty()) {
            rowSet = RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance()).build();
        }
        RowSet.Builder leftBuilder = RowSet.newBuilder();
        boolean leftIsEmpty = true;
        RowSet.Builder rightBuilder = RowSet.newBuilder();
        boolean rightIsEmpty = true;
        for (ByteString key : rowSet.getRowKeysList()) {
            if (ByteStringComparator.INSTANCE.compare(key, splitPoint) <= 0) {
                leftBuilder.addRowKeys(key);
                leftIsEmpty = false;
                continue;
            }
            rightBuilder.addRowKeys(key);
            rightIsEmpty = false;
        }
        for (RowRange range : rowSet.getRowRangesList()) {
            StartPoint startPoint = StartPoint.extract(range);
            int startCmp = ComparisonChain.start().compare((Object)startPoint.value, (Object)splitPoint, (Comparator)ByteStringComparator.INSTANCE).compareTrueFirst(startPoint.isClosed, true).result();
            if (startCmp > 0) {
                rightBuilder.addRowRanges(range);
                rightIsEmpty = false;
                continue;
            }
            EndPoint endPoint = EndPoint.extract(range);
            int endCmp = ComparisonChain.start().compareFalseFirst(endPoint.value.isEmpty(), false).compare((Object)endPoint.value, (Object)splitPoint, (Comparator)ByteStringComparator.INSTANCE).result();
            if (endCmp <= 0) {
                leftBuilder.addRowRanges(range);
                leftIsEmpty = false;
                continue;
            }
            leftBuilder.addRowRanges(range.toBuilder().setEndKeyClosed(splitPoint));
            leftIsEmpty = false;
            rightBuilder.addRowRanges(range.toBuilder().setStartKeyOpen(splitPoint));
            rightIsEmpty = false;
        }
        return Split.of(leftIsEmpty ? null : leftBuilder.build(), rightIsEmpty ? null : rightBuilder.build());
    }

    @Nonnull
    public static List<RowSet> shard(@Nonnull RowSet rowSet, @Nonnull SortedSet<ByteString> splitPoints) {
        RowSet.Builder segment;
        if (rowSet.getRowKeysList().isEmpty() && rowSet.getRowRangesList().isEmpty()) {
            rowSet = RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance()).build();
        }
        ArrayDeque keys = rowSet.getRowKeysList().stream().sorted(ByteStringComparator.INSTANCE).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayDeque ranges = rowSet.getRowRangesList().stream().sorted(Comparator.comparing(StartPoint::extract)).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayList<RowSet> segments = new ArrayList<RowSet>();
        for (ByteString splitPoint : splitPoints) {
            Preconditions.checkArgument((!splitPoint.isEmpty() ? 1 : 0) != 0, (Object)"Can't handle empty splitPoints");
            segment = RowSet.newBuilder();
            boolean currentSegmentIsEmpty = true;
            while (!keys.isEmpty() && ByteStringComparator.INSTANCE.compare((ByteString)keys.peek(), splitPoint) < 0) {
                segment.addRowKeys((ByteString)keys.poll());
                currentSegmentIsEmpty = false;
            }
            while (!ranges.isEmpty()) {
                StartPoint startPoint = StartPoint.extract((RowRange)ranges.peek());
                int startCmp = ComparisonChain.start().compareTrueFirst(startPoint.value.isEmpty(), false).compare((Object)startPoint.value, (Object)splitPoint, (Comparator)ByteStringComparator.INSTANCE).result();
                if (startCmp >= 0) break;
                RowRange range = (RowRange)ranges.poll();
                EndPoint endPoint = EndPoint.extract(range);
                int endCmp = ComparisonChain.start().compareFalseFirst(endPoint.value.isEmpty(), false).compare((Object)endPoint.value, (Object)splitPoint, (Comparator)ByteStringComparator.INSTANCE).compareFalseFirst(endPoint.isClosed, true).result();
                if (endCmp < 0) {
                    segment.addRowRanges(range);
                    currentSegmentIsEmpty = false;
                    continue;
                }
                segment.addRowRanges(range.toBuilder().setEndKeyOpen(splitPoint));
                currentSegmentIsEmpty = false;
                ranges.addFirst(range.toBuilder().setStartKeyClosed(splitPoint).build());
            }
            if (currentSegmentIsEmpty) continue;
            segments.add(segment.build());
        }
        if (!keys.isEmpty() || !ranges.isEmpty()) {
            segment = RowSet.newBuilder().addAllRowKeys((Iterable)keys).addAllRowRanges((Iterable)ranges);
            segments.add(segment.build());
        }
        return segments;
    }

    public static Range.ByteStringRange getBound(RowSet rowSet) {
        ByteString minKey = null;
        ByteString maxKey = null;
        for (ByteString key : rowSet.getRowKeysList()) {
            if (minKey == null || ByteStringComparator.INSTANCE.compare(minKey, key) > 0) {
                minKey = key;
            }
            if (maxKey != null && ByteStringComparator.INSTANCE.compare(maxKey, key) >= 0) continue;
            maxKey = key;
        }
        StartPoint minStartPoint = null;
        EndPoint maxEndPoint = null;
        if (minKey != null) {
            minStartPoint = new StartPoint(minKey, true);
        }
        if (maxKey != null) {
            maxEndPoint = new EndPoint(maxKey, true);
        }
        for (RowRange rowRange : rowSet.getRowRangesList()) {
            StartPoint currentStartPoint = StartPoint.extract(rowRange);
            if (minStartPoint == null || minStartPoint.compareTo(currentStartPoint) > 0) {
                minStartPoint = currentStartPoint;
            }
            EndPoint currentEndpoint = EndPoint.extract(rowRange);
            if (maxEndPoint != null && maxEndPoint.compareTo(currentEndpoint) >= 0) continue;
            maxEndPoint = currentEndpoint;
        }
        Range.ByteStringRange boundingRange = Range.ByteStringRange.unbounded();
        if (minStartPoint != null) {
            if (minStartPoint.isClosed) {
                boundingRange.startClosed(minStartPoint.value);
            } else {
                boundingRange.startOpen(minStartPoint.value);
            }
        }
        if (maxEndPoint != null) {
            if (maxEndPoint.isClosed) {
                boundingRange.endClosed(maxEndPoint.value);
            } else {
                boundingRange.endOpen(maxEndPoint.value);
            }
        }
        return boundingRange;
    }

    private static final class EndPoint
    implements Comparable<EndPoint> {
        private final ByteString value;
        private final boolean isClosed;

        @Nonnull
        static EndPoint extract(@Nonnull RowRange rowRange) {
            switch (rowRange.getEndKeyCase()) {
                case ENDKEY_NOT_SET: {
                    return new EndPoint(ByteString.EMPTY, true);
                }
                case END_KEY_CLOSED: {
                    return new EndPoint(rowRange.getEndKeyClosed(), true);
                }
                case END_KEY_OPEN: {
                    if (rowRange.getEndKeyOpen().isEmpty()) {
                        return new EndPoint(ByteString.EMPTY, true);
                    }
                    return new EndPoint(rowRange.getEndKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown endKeyCase: " + rowRange.getEndKeyCase());
        }

        EndPoint(@Nonnull ByteString value, boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        public int compareTo(@Nonnull EndPoint o) {
            return ComparisonChain.start().compareFalseFirst(this.value.isEmpty(), o.value.isEmpty()).compare((Object)this.value, (Object)o.value, (Comparator)ByteStringComparator.INSTANCE).compareFalseFirst(this.isClosed, o.isClosed).result();
        }
    }

    private static final class StartPoint
    implements Comparable<StartPoint> {
        private final ByteString value;
        private final boolean isClosed;

        @Nonnull
        static StartPoint extract(@Nonnull RowRange rowRange) {
            switch (rowRange.getStartKeyCase()) {
                case STARTKEY_NOT_SET: {
                    return new StartPoint(ByteString.EMPTY, true);
                }
                case START_KEY_CLOSED: {
                    return new StartPoint(rowRange.getStartKeyClosed(), true);
                }
                case START_KEY_OPEN: {
                    if (rowRange.getStartKeyOpen().isEmpty()) {
                        return new StartPoint(ByteString.EMPTY, true);
                    }
                    return new StartPoint(rowRange.getStartKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown startKeyCase: " + rowRange.getStartKeyCase());
        }

        StartPoint(@Nonnull ByteString value, boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        public int compareTo(@Nonnull StartPoint o) {
            return ComparisonChain.start().compareTrueFirst(this.value.isEmpty(), o.value.isEmpty()).compare((Object)this.value, (Object)o.value, (Comparator)ByteStringComparator.INSTANCE).compareTrueFirst(this.isClosed, o.isClosed).result();
        }
    }

    @InternalApi
    @AutoValue
    public static abstract class Split {
        @Nullable
        public abstract RowSet getLeft();

        @Nullable
        public abstract RowSet getRight();

        public static Split of(RowSet left, RowSet right) {
            return new AutoValue_RowSetUtil_Split(left, right);
        }
    }
}

