/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Exchanger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, SmallTests.class})
public class TestForceUpdateProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestForceUpdateProcedure.class);
    private static HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private static WALProcedureStore STORE;
    private static ProcedureExecutor<Void> EXEC;
    private static Exchanger<Boolean> EXCHANGER;
    private static int WAL_COUNT;
    @Rule
    public final TestName name = new TestName();

    private void createStoreAndExecutor() throws IOException {
        UTIL.getConfiguration().setInt("hbase.procedure.cleaner.interval", 1000);
        Path logDir = UTIL.getDataTestDir(this.name.getMethodName());
        STORE = ProcedureTestingUtility.createWalStore(UTIL.getConfiguration(), logDir);
        STORE.start(1);
        EXEC = new ProcedureExecutor(UTIL.getConfiguration(), null, (ProcedureStore)STORE);
        ProcedureTestingUtility.initAndStartWorkers(EXEC, 1, true);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        UTIL.getConfiguration().setInt("hbase.procedure.store.wal.warn.threshold", WAL_COUNT);
    }

    private void stopStoreAndExecutor() {
        EXEC.stop();
        STORE.stop(false);
        EXEC = null;
        STORE = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        this.createStoreAndExecutor();
    }

    @After
    public void tearDown() {
        this.stopStoreAndExecutor();
    }

    @Test
    public void testProcedureStuck() throws IOException, InterruptedException {
        EXEC.submitProcedure((Procedure)new ParentProcedure());
        EXCHANGER.exchange(Boolean.TRUE);
        UTIL.waitFor(10000L, () -> EXEC.getActiveExecutorCount() == 0);
        long procId = EXEC.submitProcedure((Procedure)new ExchangeProcedure());
        Assert.assertEquals((long)1L, (long)STORE.getActiveLogs().size());
        for (int i = 0; i < WAL_COUNT - 1; ++i) {
            Assert.assertTrue((boolean)STORE.rollWriterForTesting());
            Assert.assertEquals((long)(2 + i), (long)STORE.getActiveLogs().size());
            EXCHANGER.exchange(Boolean.TRUE);
            Thread.sleep(1000L);
        }
        STORE.rollWriterForTesting();
        EXCHANGER.exchange(Boolean.FALSE);
        UTIL.waitFor(10000L, () -> STORE.getActiveLogs().size() <= 2);
        UTIL.waitFor(10000L, () -> EXEC.isFinished(procId));
        this.stopStoreAndExecutor();
        this.createStoreAndExecutor();
        HashMap procMap = new HashMap();
        EXEC.getActiveProceduresNoCopy().forEach(p -> procMap.put(p.getClass(), p));
        Assert.assertEquals((long)3L, (long)procMap.size());
        ParentProcedure parentProc = (ParentProcedure)((Object)procMap.get(ParentProcedure.class));
        Assert.assertEquals((Object)ProcedureProtos.ProcedureState.WAITING, (Object)parentProc.getState());
        WaitingProcedure waitingProc = (WaitingProcedure)((Object)procMap.get(WaitingProcedure.class));
        Assert.assertEquals((Object)ProcedureProtos.ProcedureState.WAITING_TIMEOUT, (Object)waitingProc.getState());
        ProcedureTestingUtility.NoopProcedure noopProc = (ProcedureTestingUtility.NoopProcedure)((Object)procMap.get(ProcedureTestingUtility.NoopProcedure.class));
        Assert.assertEquals((Object)ProcedureProtos.ProcedureState.SUCCESS, (Object)noopProc.getState());
    }

    @Test
    public void testCompletedProcedure() throws InterruptedException, IOException {
        long procId = EXEC.submitProcedure((Procedure)new ExchangeProcedure());
        EXCHANGER.exchange(Boolean.FALSE);
        UTIL.waitFor(10000L, () -> EXEC.isFinished(procId));
        for (int i = 0; i < WAL_COUNT - 1; ++i) {
            Assert.assertTrue((boolean)STORE.rollWriterForTesting());
            long pid = EXEC.submitProcedure((Procedure)new NoopNoAckProcedure());
            Assert.assertEquals((long)(2 + i), (long)STORE.getActiveLogs().size());
            UTIL.waitFor(10000L, () -> EXEC.isFinished(pid));
        }
        UTIL.waitFor(10000L, () -> EXEC.getCompletedSize() == 1);
        STORE.rollWriterForTesting();
        UTIL.waitFor(10000L, () -> STORE.getActiveLogs().size() <= 1);
    }

    static {
        EXCHANGER = new Exchanger();
        WAL_COUNT = 5;
    }

    public static final class NoopNoAckProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        protected boolean shouldWaitClientAck(Void env) {
            return false;
        }
    }

    public static final class ExchangeProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (EXCHANGER.exchange(Boolean.TRUE).booleanValue()) {
                return new Procedure[]{this};
            }
            return null;
        }
    }

    public static final class ParentProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            return new Procedure[]{new ProcedureTestingUtility.NoopProcedure(), new WaitingProcedure()};
        }
    }

    public static final class WaitingProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            EXCHANGER.exchange(Boolean.TRUE);
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.setTimeout(Integer.MAX_VALUE);
            throw new ProcedureSuspendedException();
        }
    }
}

