/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.BadAuthNettyRpcConnection;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.JVM;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestNettyIPC
extends AbstractTestIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyIPC.class);
    @Parameterized.Parameter(value=1)
    public String eventLoopType;
    private static NioEventLoopGroup NIO;
    private static EpollEventLoopGroup EPOLL;

    private static List<String> getEventLoopTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("nio");
        types.add("perClientNio");
        if (JVM.isLinux() && JVM.isAmd64()) {
            types.add("epoll");
        }
        return types;
    }

    @Parameterized.Parameters(name="{index}: rpcServerImpl={0}, EventLoop={1}")
    public static List<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String eventLoopType : TestNettyIPC.getEventLoopTypes()) {
            params.add(new Object[]{SimpleRpcServer.class, eventLoopType});
            params.add(new Object[]{NettyRpcServer.class, eventLoopType});
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        NIO = new NioEventLoopGroup();
        if (JVM.isLinux() && JVM.isAmd64()) {
            EPOLL = new EpollEventLoopGroup();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() {
        if (NIO != null) {
            NIO.shutdownGracefully();
        }
        if (EPOLL != null) {
            EPOLL.shutdownGracefully();
        }
    }

    private void setConf(Configuration conf) {
        switch (this.eventLoopType) {
            case "nio": {
                NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)conf, (EventLoopGroup)NIO, NioSocketChannel.class);
                break;
            }
            case "epoll": {
                NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)conf, (EventLoopGroup)EPOLL, EpollSocketChannel.class);
                break;
            }
            case "perClientNio": {
                NettyRpcClientConfigHelper.createEventLoopPerClient((Configuration)conf);
                break;
            }
        }
    }

    protected NettyRpcClient createRpcClientNoCodec(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf){

            Codec getCodec() {
                return null;
            }
        };
    }

    protected NettyRpcClient createRpcClient(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf);
    }

    protected NettyRpcClient createRpcClientRTEDuringConnectionSetup(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf){

            boolean isTcpNoDelay() {
                throw new RuntimeException("Injected fault");
            }
        };
    }

    @Override
    protected AbstractRpcClient<?> createBadAuthRpcClient(Configuration conf) {
        return new NettyRpcClient(conf){

            protected NettyRpcConnection createConnection(ConnectionId remoteId) throws IOException {
                return new BadAuthNettyRpcConnection(this, remoteId);
            }
        };
    }
}

