/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.SyncCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionCoprocessorRpcChannel
extends SyncCoprocessorRpcChannel {
    private static final Logger LOG = LoggerFactory.getLogger(RegionCoprocessorRpcChannel.class);
    private final TableName table;
    private final byte[] row;
    private final ClusterConnection conn;
    private byte[] lastRegion;
    private final int operationTimeout;
    private final RpcRetryingCallerFactory rpcCallerFactory;

    RegionCoprocessorRpcChannel(ClusterConnection conn, TableName table, byte[] row) {
        this.table = table;
        this.row = row;
        this.conn = conn;
        this.operationTimeout = conn.getConnectionConfiguration().getOperationTimeout();
        this.rpcCallerFactory = conn.getRpcRetryingCallerFactory();
    }

    @Override
    protected Message callExecService(RpcController controller, final Descriptors.MethodDescriptor method, final Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Call: " + method.getName() + ", " + request.toString());
        }
        if (this.row == null) {
            throw new NullPointerException("Can't be null!");
        }
        final Context context = Context.current();
        ClientServiceCallable<ClientProtos.CoprocessorServiceResponse> callable = new ClientServiceCallable<ClientProtos.CoprocessorServiceResponse>((Connection)this.conn, this.table, this.row, (org.apache.hbase.thirdparty.com.google.protobuf.RpcController)this.conn.getRpcControllerFactory().newController(), -1){

            @Override
            protected ClientProtos.CoprocessorServiceResponse rpcCall() throws Exception {
                try (Scope ignored = context.makeCurrent();){
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request, RegionCoprocessorRpcChannel.this.row, regionName);
                    ClientProtos.CoprocessorServiceResponse coprocessorServiceResponse = ((ClientProtos.ClientService.BlockingInterface)this.getStub()).execService(this.getRpcController(), csr);
                    return coprocessorServiceResponse;
                }
            }
        };
        ClientProtos.CoprocessorServiceResponse result = this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
        this.lastRegion = result.getRegion().getValue().toByteArray();
        return CoprocessorRpcUtils.getResponse(result, responsePrototype);
    }

    public byte[] getLastRegion() {
        return this.lastRegion;
    }
}

