/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class QualifierFilter
extends CompareFilter {
    @Deprecated
    public QualifierFilter(CompareFilter.CompareOp op, ByteArrayComparable qualifierComparator) {
        super(op, qualifierComparator);
    }

    public QualifierFilter(CompareOperator op, ByteArrayComparable qualifierComparator) {
        super(op, qualifierComparator);
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.compareQualifier(this.getCompareOperator(), this.comparator, c)) {
            return Filter.ReturnCode.SKIP;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Object> arguments = CompareFilter.extractArguments(filterArguments);
        CompareOperator compareOp = (CompareOperator)((Object)arguments.get(0));
        ByteArrayComparable comparator = (ByteArrayComparable)arguments.get(1);
        return new QualifierFilter(compareOp, comparator);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.QualifierFilter.Builder builder = FilterProtos.QualifierFilter.newBuilder();
        builder.setCompareFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static QualifierFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.QualifierFilter proto;
        try {
            proto = FilterProtos.QualifierFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        CompareOperator valueCompareOp = CompareOperator.valueOf(proto.getCompareFilter().getCompareOp().name());
        ByteArrayComparable valueComparator = null;
        try {
            if (proto.getCompareFilter().hasComparator()) {
                valueComparator = ProtobufUtil.toComparator(proto.getCompareFilter().getComparator());
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException((Throwable)ioe);
        }
        return new QualifierFilter(valueCompareOp, valueComparator);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QualifierFilter)) {
            return false;
        }
        return super.areSerializedFieldsEqual(o);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

