/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.HdfsActionUtils;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.proto.HAZKInfoProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartActiveNameNodeAction
extends RestartActionBaseAction {
    private static final Logger LOG = LoggerFactory.getLogger(RestartActiveNameNodeAction.class);
    private static final String ACTIVE_NN_LOCK_NAME = "ActiveStandbyElectorLock";
    private static final String ZK_PARENT_ZNODE_DEFAULT = "/hadoop-ha";
    private static final String ZK_PARENT_ZNODE_KEY = "ha.zookeeper.parent-znode";

    public RestartActiveNameNodeAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        String hadoopHAZkNode;
        this.getLogger().info("Performing action: Restart active namenode");
        String activeNamenode = null;
        int activeNamenodePort = -1;
        try (DistributedFileSystem dfs = HdfsActionUtils.createDfs(this.getConf());){
            Configuration conf = dfs.getConf();
            hadoopHAZkNode = conf.get(ZK_PARENT_ZNODE_KEY, ZK_PARENT_ZNODE_DEFAULT);
            String nameServiceID = DFSUtil.getNamenodeNameServiceId((Configuration)conf);
            if (!HAUtil.isHAEnabled((Configuration)conf, (String)nameServiceID)) {
                this.getLogger().info("HA for HDFS is not enabled; skipping");
                return;
            }
            try (ZKWatcher zkw = new ZKWatcher(conf, "get-active-namenode", null);){
                RecoverableZooKeeper rzk = zkw.getRecoverableZooKeeper();
                String hadoopHAZkNodePath = ZNodePaths.joinZNode((String)(hadoopHAZkNode != null && hadoopHAZkNode.equals("/") ? "" : hadoopHAZkNode), (String)nameServiceID);
                List subChildren = Optional.ofNullable(ZKUtil.listChildrenNoWatch((ZKWatcher)zkw, (String)hadoopHAZkNodePath)).orElse(Collections.emptyList());
                for (String eachEntry : subChildren) {
                    if (!eachEntry.contains(ACTIVE_NN_LOCK_NAME)) continue;
                    byte[] data = rzk.getData(ZNodePaths.joinZNode((String)hadoopHAZkNodePath, (String)ACTIVE_NN_LOCK_NAME), false, null);
                    HAZKInfoProtos.ActiveNodeInfo proto = HAZKInfoProtos.ActiveNodeInfo.parseFrom((byte[])data);
                    activeNamenode = proto.getHostname();
                    activeNamenodePort = proto.getPort();
                }
            }
        }
        if (activeNamenode == null) {
            this.getLogger().info("No active Name node found in zookeeper under '{}'", (Object)hadoopHAZkNode);
            return;
        }
        this.getLogger().info("Found Active NameNode host: {}", activeNamenode);
        ServerName activeNNHost = ServerName.valueOf(activeNamenode, (int)activeNamenodePort, (long)-1L);
        this.getLogger().info("Restarting Active NameNode: {}", activeNamenode);
        this.restartNameNode(activeNNHost, this.sleepTime);
    }
}

