/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.HdfsActionUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpHdfsClusterStatusAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(DumpHdfsClusterStatusAction.class);
    private static final String PREFIX = "\n  ";

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        StringBuilder sb = new StringBuilder();
        try (DistributedFileSystem dfs = HdfsActionUtils.createDfs(this.getConf());){
            Configuration dfsConf = dfs.getConf();
            URI dfsUri = dfs.getUri();
            boolean isHaAndLogicalUri = HAUtilClient.isLogicalUri((Configuration)dfsConf, (URI)dfsUri);
            sb.append("Cluster status").append('\n');
            if (isHaAndLogicalUri) {
                String nsId = dfsUri.getHost();
                List namenodes = HAUtil.getProxiesForAllNameNodesInNameservice((Configuration)dfsConf, (String)nsId);
                boolean atLeastOneActive = HAUtil.isAtLeastOneActive((List)namenodes);
                InetSocketAddress activeAddress = HAUtil.getAddressOfActive((FileSystem)dfs);
                sb.append("Active NameNode=").append(activeAddress).append(", isAtLeastOneActive=").append(atLeastOneActive).append('\n');
            }
            DatanodeInfo[] dns = dfs.getClient().datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            sb.append("Number of live DataNodes: ").append(dns.length);
            for (DatanodeInfo dni : dns) {
                sb.append(PREFIX).append("name=").append(dni.getName()).append(", used%=").append(dni.getDfsUsedPercent()).append(", capacity=").append(FileUtils.byteCountToDisplaySize((long)dni.getCapacity()));
            }
            sb.append('\n');
            dns = dfs.getClient().datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            sb.append("Number of dead DataNodes: ").append(dns.length);
            for (DatanodeInfo dni : dns) {
                sb.append(PREFIX).append(dni.getName()).append("/").append(dni.getNetworkLocation());
            }
        }
        this.getLogger().info(sb.toString());
    }
}

