/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngestWithEncryption
extends IntegrationTestIngest {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestIngestWithEncryption.class);
    boolean initialized = false;

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(null);
        Configuration conf = this.util.getConfiguration();
        if (!this.util.isDistributedCluster()) {
            conf.setInt("hfile.format.version", 3);
            conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
            conf.set("hbase.crypto.master.key.name", "hbase");
            conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, WAL.Reader.class);
            conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, WALProvider.Writer.class);
            conf.setBoolean("hbase.regionserver.wal.encryption", true);
        }
        try {
            EncryptionTest.testEncryption((Configuration)conf, (String)"AES", null);
        }
        catch (Exception e) {
            LOG.warn("Encryption configuration test did not pass, skipping test", (Throwable)e);
            return;
        }
        super.setUpCluster();
        this.initialized = true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (!this.initialized) {
            return;
        }
        final Admin admin = this.util.getAdmin();
        TableDescriptor tableDescriptor = admin.getDescriptor(this.getTablename());
        for (ColumnFamilyDescriptor columnDescriptor : tableDescriptor.getColumnFamilies()) {
            ColumnFamilyDescriptor updatedColumn = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)columnDescriptor).setEncryptionType("AES").build();
            LOG.info("Updating CF schema for " + this.getTablename() + "." + columnDescriptor.getNameAsString());
            admin.disableTable(this.getTablename());
            admin.modifyColumnFamily(this.getTablename(), updatedColumn);
            admin.enableTable(this.getTablename());
            this.util.waitFor(30000L, 1000L, true, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

                public boolean evaluate() throws IOException {
                    return admin.isTableAvailable(IntegrationTestIngestWithEncryption.this.getTablename());
                }
            });
        }
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        if (!this.initialized) {
            return 0;
        }
        return super.runTestFromCommandLine();
    }

    @Override
    public void cleanUp() throws Exception {
        if (!this.initialized) {
            return;
        }
        super.cleanUp();
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestIngestWithEncryption(), (String[])args);
        System.exit(ret);
    }
}

