/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Cursor;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.server.core.avltree.ArrayMarshaller;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.partition.impl.btree.mavibot.KeyTupleArrayCursor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotCursor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.ValueTreeCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotTable<K, V>
extends AbstractTable<K, V> {
    private BTree<K, V> bt;
    private ArrayMarshaller<V> arrayMarshaller;
    private static final Logger LOG = LoggerFactory.getLogger(MavibotTable.class);
    protected RecordManager recordMan;

    public MavibotTable(RecordManager recordMan, SchemaManager schemaManager, String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates) throws IOException {
        super(schemaManager, name, keySerializer.getComparator(), valueSerializer.getComparator());
        this.recordMan = recordMan;
        this.bt = recordMan.getManagedTree(name);
        if (this.bt == null) {
            this.bt = new BTree(name, keySerializer, valueSerializer, allowDuplicates);
            try {
                recordMan.manage(this.bt);
            }
            catch (BTreeAlreadyManagedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.bt.setKeySerializer(keySerializer);
            this.bt.setValueSerializer(valueSerializer);
        }
        this.allowsDuplicates = allowDuplicates;
        this.arrayMarshaller = new ArrayMarshaller(this.valueComparator);
        this.count = this.bt.getNbElems();
    }

    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    public boolean has(K key) throws IOException {
        return this.bt.hasKey(key);
    }

    public boolean has(K key, V value) throws LdapException {
        try {
            return this.bt.contains(key, value);
        }
        catch (IOException e) {
            throw new LdapException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGreaterOrEqual(K key) throws Exception {
        Cursor cursor = null;
        try {
            cursor = this.bt.browseFrom(key);
            boolean bl = cursor.hasNext();
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLessOrEqual(K key) throws Exception {
        Cursor cursor = null;
        try {
            cursor = this.bt.browseFrom(key);
            org.apache.directory.mavibot.btree.Tuple tuple = null;
            if (cursor.hasNext()) {
                tuple = cursor.next();
            }
            if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
                boolean bl = true;
                return bl;
            }
            if (null == tuple) {
                boolean bl = this.count > 0L;
                return bl;
            }
            if (cursor.hasPrev()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public boolean hasGreaterOrEqual(K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_593, (Object[])new Object[0]));
        }
        Cursor cursor = null;
        try {
            if (!this.bt.hasKey(key)) {
                boolean bl = false;
                return bl;
            }
            BTree dups = this.bt.getValues(key);
            cursor = dups.browseFrom(val);
            boolean bl = cursor.hasNext();
            return bl;
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLessOrEqual(K key, V val) throws Exception {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_593, (Object[])new Object[0]));
        }
        if (!this.bt.hasKey(key)) {
            return false;
        }
        BTree dups = this.bt.getValues(key);
        Cursor cursor = null;
        try {
            cursor = dups.browseFrom(val);
            org.apache.directory.mavibot.btree.Tuple tuple = null;
            if (cursor.hasNext()) {
                tuple = cursor.next();
            }
            if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
                boolean bl = true;
                return bl;
            }
            if (null == tuple) {
                boolean bl = this.count > 0L;
                return bl;
            }
            if (cursor.hasPrev()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public V get(K key) throws LdapException {
        if (key == null) {
            return null;
        }
        try {
            return (V)this.bt.get(key);
        }
        catch (KeyNotFoundException knfe) {
            return null;
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public void put(K key, V value) throws Exception {
        try {
            if (value == null || key == null) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_594, (Object[])new Object[0]));
            }
            Object replaced = this.bt.insert(key, value);
            if (replaced == null) {
                ++this.count;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_131, (Object[])new Object[]{key, this.name}), (Throwable)e);
            throw e;
        }
    }

    public void remove(K key) throws Exception {
        block4: {
            try {
                if (key == null) {
                    return;
                }
                org.apache.directory.mavibot.btree.Tuple returned = this.bt.delete(key);
                if (null == returned) {
                    return;
                }
                --this.count;
            }
            catch (Exception e) {
                LOG.error(I18n.err((I18n)I18n.ERR_133, (Object[])new Object[]{key, this.name}), (Throwable)e);
                if (!(e instanceof IOException)) break block4;
                throw (IOException)e;
            }
        }
    }

    public void remove(K key, V value) throws Exception {
        try {
            if (key == null) {
                return;
            }
            org.apache.directory.mavibot.btree.Tuple t = this.bt.delete(key, value);
            if (t != null) {
                --this.count;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_132, (Object[])new Object[]{key, value, this.name}), (Throwable)e);
        }
    }

    public org.apache.directory.api.ldap.model.cursor.Cursor<Tuple<K, V>> cursor() throws LdapException {
        return new MavibotCursor(this);
    }

    public org.apache.directory.api.ldap.model.cursor.Cursor<Tuple<K, V>> cursor(K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor();
        }
        try {
            if (!this.allowsDuplicates) {
                Object val = this.bt.get(key);
                return new SingletonCursor((Object)new Tuple(key, val));
            }
            BTree dups = this.bt.getValues(key);
            return new KeyTupleArrayCursor(dups, key);
        }
        catch (KeyNotFoundException knfe) {
            return new EmptyCursor();
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public org.apache.directory.api.ldap.model.cursor.Cursor<V> valueCursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        try {
            if (!this.allowsDuplicates) {
                Object val = this.bt.get(key);
                return new SingletonCursor(val);
            }
            BTree dups = this.bt.getValues(key);
            return new ValueTreeCursor(dups);
        }
        catch (KeyNotFoundException knfe) {
            return new EmptyCursor();
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public long count(K key) throws Exception {
        if (key == null) {
            return 0L;
        }
        try {
            if (this.bt.isAllowDuplicates()) {
                BTree values = this.bt.getValues(key);
                return values.getNbElems();
            }
            this.bt.get(key);
            return 1L;
        }
        catch (KeyNotFoundException knfe) {
            return 0L;
        }
    }

    public long greaterThanCount(K key) throws Exception {
        return Math.min(this.count, 10L);
    }

    public long lessThanCount(K key) throws Exception {
        return Math.min(this.count, 10L);
    }

    public void close() throws Exception {
    }

    public ArrayTree<V> getDupsContainer(byte[] serialized) throws IOException {
        if (serialized == null) {
            return new ArrayTree(this.valueComparator);
        }
        return this.arrayMarshaller.deserialize(serialized);
    }

    protected BTree<K, V> getBTree() {
        return this.bt;
    }

    public synchronized void sync() throws IOException {
    }
}

