/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotParentIdAndRdnSerializer
implements ElementSerializer<ParentIdAndRdn> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MavibotParentIdAndRdnSerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static SchemaManager schemaManager;
    private Comparator<ParentIdAndRdn> comparator = new Comparator<ParentIdAndRdn>(){

        @Override
        public int compare(ParentIdAndRdn rdn1, ParentIdAndRdn rdn2) {
            return rdn1.compareTo(rdn2);
        }
    };

    public byte[] serialize(ParentIdAndRdn parentIdAndRdn) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int totalBytes = 0;
            baos.write(0);
            baos.write(0);
            baos.write(0);
            baos.write(0);
            ObjectOutputStream out = new ObjectOutputStream(baos);
            Rdn[] rdns = parentIdAndRdn.getRdns();
            if (rdns == null || rdns.length == 0) {
                out.writeByte(0);
            } else {
                out.writeByte(rdns.length);
                for (Rdn rdn : rdns) {
                    rdn.writeExternal((ObjectOutput)out);
                }
            }
            out.writeUTF(parentIdAndRdn.getParentId());
            out.writeInt(parentIdAndRdn.getNbChildren());
            out.writeInt(parentIdAndRdn.getNbDescendants());
            out.flush();
            if (IS_DEBUG) {
                LOG.debug(">------------------------------------------------");
                LOG.debug("Serialize " + parentIdAndRdn);
            }
            byte[] bytes = baos.toByteArray();
            totalBytes = bytes.length - 4;
            bytes[0] = (byte)(totalBytes >>> 24);
            bytes[1] = (byte)(totalBytes >>> 16);
            bytes[2] = (byte)(totalBytes >>> 8);
            bytes[3] = (byte)totalBytes;
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ParentIdAndRdn deserialize(BufferHandler bufferHandler) throws IOException {
        return this.deserialize(ByteBuffer.wrap(bufferHandler.getBuffer()));
    }

    public ParentIdAndRdn deserialize(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.array(), buffer.position(), len));
        try {
            ParentIdAndRdn parentIdAndRdn = new ParentIdAndRdn();
            int nbRdns = in.readByte();
            if (nbRdns == 0) {
                parentIdAndRdn.setRdns(new Rdn[0]);
            } else {
                Rdn[] rdns = new Rdn[nbRdns];
                for (int i = 0; i < nbRdns; ++i) {
                    Rdn rdn = new Rdn(schemaManager);
                    rdn.readExternal((ObjectInput)in);
                    rdns[i] = rdn;
                }
                parentIdAndRdn.setRdns(rdns);
            }
            String uuid = in.readUTF();
            parentIdAndRdn.setParentId(uuid);
            int nbChildren = in.readInt();
            int nbDescendants = in.readInt();
            parentIdAndRdn.setNbChildren(nbChildren);
            parentIdAndRdn.setNbDescendants(nbDescendants);
            buffer.position(buffer.position() + len);
            return parentIdAndRdn;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err((I18n)I18n.ERR_134, (Object[])new Object[]{cnfe.getLocalizedMessage()}));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }

    public int compare(ParentIdAndRdn type1, ParentIdAndRdn type2) {
        return type1.compareTo(type2);
    }

    public Comparator<ParentIdAndRdn> getComparator() {
        return this.comparator;
    }

    public static void setSchemaManager(SchemaManager schemaManager) {
        MavibotParentIdAndRdnSerializer.schemaManager = schemaManager;
    }
}

