/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import net.spy.memcached.KeyUtil;
import net.spy.memcached.ObserveResponse;
import net.spy.memcached.ops.ObserveOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.protocol.binary.SingleKeyOperationImpl;

class ObserveOperationImpl
extends SingleKeyOperationImpl
implements ObserveOperation {
    private static final byte CMD = -110;
    private final long cas;
    private final int index;
    private byte keystate = (byte)-1;
    private long retCas = 0L;

    public ObserveOperationImpl(String k, long c, int i, OperationCallback cb) {
        super((byte)-110, ObserveOperationImpl.generateOpaque(), k, cb);
        this.cas = c;
        this.index = i;
    }

    @Override
    public void initialize() {
        byte[] keyBytes = KeyUtil.getKeyBytes(this.key);
        this.prepareBuffer("", 0L, EMPTY_BYTES, (short)this.index, (short)keyBytes.length, keyBytes);
    }

    @Override
    public String toString() {
        return super.toString() + " Cas: " + this.cas;
    }

    @Override
    protected void decodePayload(byte[] pl) {
        short keylen = (short)ObserveOperationImpl.decodeShort(pl, 2);
        this.keystate = (byte)ObserveOperationImpl.decodeByte(pl, keylen + 4);
        this.retCas = ObserveOperationImpl.decodeLong(pl, keylen + 5);
        ObserveResponse r = ObserveResponse.valueOf(this.keystate);
        ((ObserveOperation.Callback)this.getCallback()).gotData(this.key, this.retCas, this.getHandlingNode(), r);
        this.getCallback().receivedStatus(STATUS_OK);
    }

    @Override
    public long getCasValue() {
        return this.cas;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

