/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.SimpleScanResultConsumer;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.trace.TraceUtil;

class TracedScanResultConsumer
implements SimpleScanResultConsumer {
    private final SimpleScanResultConsumer delegate;

    public TracedScanResultConsumer(SimpleScanResultConsumer delegate) {
        this.delegate = delegate;
    }

    public void onScanMetricsCreated(ScanMetrics scanMetrics) {
        TraceUtil.trace(() -> this.delegate.onScanMetricsCreated(scanMetrics), (String)"TracedScanResultConsumer#onScanMetricsCreated");
    }

    public boolean onNext(Result result) {
        return (Boolean)TraceUtil.trace(() -> this.delegate.onNext(result), (String)"TracedScanResultConsumer#onNext");
    }

    public void onError(Throwable error) {
        TraceUtil.trace(() -> this.delegate.onError(error), (String)"TracedScanResultConsumer#onError");
    }

    public void onComplete() {
        TraceUtil.trace(() -> ((SimpleScanResultConsumer)this.delegate).onComplete(), (String)"TracedScanResultConsumer#onComplete");
    }

    @Override
    public List<Result> getAll() throws Exception {
        return this.delegate.getAll();
    }

    @Override
    public ScanMetrics getScanMetrics() {
        return this.delegate.getScanMetrics();
    }
}

