/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.junit.Assert;
import org.junit.Test;

public class TestNameCache {
    @Test
    public void testDictionary() throws Exception {
        NameCache cache = new NameCache(2);
        String[] matching = new String[]{"part1", "part10000000", "fileabc", "abc", "filepart"};
        String[] notMatching = new String[]{"spart1", "apart", "abcd", "def"};
        for (String s : matching) {
            cache.put((Object)s);
            Assert.assertTrue((s == cache.put((Object)s) ? 1 : 0) != 0);
        }
        for (String s : notMatching) {
            cache.put((Object)s);
        }
        cache.initialized();
        for (String s : matching) {
            this.verifyNameReuse((NameCache<String>)cache, s, true);
        }
        Assert.assertEquals((long)matching.length, (long)cache.size());
        for (String s : notMatching) {
            this.verifyNameReuse((NameCache<String>)cache, s, false);
        }
        cache.reset();
        cache.initialized();
        for (String s : matching) {
            this.verifyNameReuse((NameCache<String>)cache, s, false);
        }
        for (String s : notMatching) {
            this.verifyNameReuse((NameCache<String>)cache, s, false);
        }
    }

    private void verifyNameReuse(NameCache<String> cache, String s, boolean reused) {
        cache.put((Object)s);
        int lookupCount = cache.getLookupCount();
        if (reused) {
            Assert.assertNotNull((Object)cache.put((Object)s));
            Assert.assertEquals((long)(lookupCount + 1), (long)cache.getLookupCount());
        } else {
            Assert.assertNull((Object)cache.put((Object)s));
            Assert.assertEquals((long)lookupCount, (long)cache.getLookupCount());
        }
    }
}

