/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJspHelper {
    private final Configuration conf = new HdfsConfiguration();
    private static String clientAddr = "1.1.1.1";
    private static String chainedClientAddr = clientAddr + ", 2.2.2.2";
    private static String proxyAddr = "3.3.3.3";

    @BeforeClass
    public static void setupKerb() {
        System.setProperty("java.security.krb5.kdc", "");
        System.setProperty("java.security.krb5.realm", "NONE");
    }

    @Test
    public void testGetUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String user = "TheDoctor";
        Text userText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(userText, userText, null);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn((Object)"1.1.1.1:1111");
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.verifyServiceInToken(context, request, "1.1.1.1:1111");
        ((DelegationTokenIdentifier)token.decodeIdentifier()).clearCache();
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn(null);
        InetSocketAddress addr = new InetSocketAddress("localhost", 2222);
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn((Object)addr);
        this.verifyServiceInToken(context, request, addr.getAddress().getHostAddress() + ":2222");
        userText = new Text(user + "2");
        dtId = new DelegationTokenIdentifier(userText, userText, null);
        token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        token.setService(new Text("3.3.3.3:3333"));
        tokenString = token.encodeToUrlString();
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn(null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        this.verifyServiceInToken(context, request, "3.3.3.3:3333");
    }

    private void verifyServiceInToken(ServletContext context, HttpServletRequest request, String expected) throws IOException {
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Token tokenInUgi = (Token)ugi.getTokens().iterator().next();
        Assert.assertEquals((Object)expected, (Object)tokenInUgi.getService().toString());
    }

    @Test
    public void testGetUgiFromToken() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        Text ownerText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(ownerText, ownerText, new Text(realUser));
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        HttpServletRequest request = this.getMockRequest(null, null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(realUser, null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest("rogue", null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(null, user, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(null, null, "rogue");
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=rogue != expected=" + user), (Object)ioe.getMessage());
        }
        request = this.getMockRequest(null, user, "rogue");
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=rogue != expected=" + user), (Object)ioe.getMessage());
        }
    }

    @Test
    public void testGetNonProxyUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        HttpServletRequest request = this.getMockRequest(null, null, null);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(null, realUser, null);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(realUser, null, null);
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)realUser);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, realUser, null);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)realUser);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, user, null);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=" + user + " != expected=" + realUser), (Object)ioe.getMessage());
        }
    }

    @Test
    public void testGetProxyUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(realUser), "*");
        this.conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(realUser), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        HttpServletRequest request = this.getMockRequest(null, null, user);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(null, realUser, user);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(realUser, null, user);
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, realUser, user);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, user, user);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=" + user + " != expected=" + realUser), (Object)ioe.getMessage());
        }
        try {
            request = this.getMockRequest(user, null, realUser);
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad proxy request allowed");
        }
        catch (AuthorizationException ae) {
            Assert.assertEquals((Object)("User: " + user + " is not allowed to impersonate " + realUser), (Object)ae.getMessage());
        }
        try {
            request = this.getMockRequest(user, user, realUser);
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad proxy request allowed");
        }
        catch (AuthorizationException ae) {
            Assert.assertEquals((Object)("User: " + user + " is not allowed to impersonate " + realUser), (Object)ae.getMessage());
        }
    }

    @Test
    public void testGetUgiDuringStartup() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        Text ownerText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(ownerText, ownerText, new Text(realUser));
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        HttpServletRequest request = this.getMockRequest(realUser, null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        NameNode mockNN = (NameNode)Mockito.mock(NameNode.class);
        Mockito.when((Object)mockNN.getNamesystem()).thenReturn(null);
        Mockito.when((Object)context.getAttribute("name.node")).thenReturn((Object)mockNN);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        }
        catch (RetriableException e) {
            Assert.assertEquals((Object)"Namenode is in startup mode", (Object)e.getMessage());
        }
    }

    private HttpServletRequest getMockRequest(String remoteUser, String user, String doAs) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("user.name")).thenReturn((Object)user);
        if (doAs != null) {
            Mockito.when((Object)request.getParameter("doas")).thenReturn((Object)doAs);
        }
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)remoteUser);
        return request;
    }

    private void checkUgiFromAuth(UserGroupInformation ugi) {
        if (ugi.getRealUser() != null) {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)ugi.getAuthenticationMethod());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, (Object)ugi.getRealUser().getAuthenticationMethod());
        } else {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, (Object)ugi.getAuthenticationMethod());
        }
    }

    private void checkUgiFromToken(UserGroupInformation ugi) {
        if (ugi.getRealUser() != null) {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)ugi.getAuthenticationMethod());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)ugi.getRealUser().getAuthenticationMethod());
        } else {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)ugi.getAuthenticationMethod());
        }
    }

    @Test
    public void testReadWriteReplicaState() {
        try {
            DataOutputBuffer out = new DataOutputBuffer();
            DataInputBuffer in = new DataInputBuffer();
            for (HdfsServerConstants.ReplicaState repState : HdfsServerConstants.ReplicaState.values()) {
                repState.write((DataOutput)out);
                in.reset(out.getData(), out.getLength());
                HdfsServerConstants.ReplicaState result = HdfsServerConstants.ReplicaState.read((DataInput)in);
                Assert.assertTrue((String)"testReadWrite error !!!", (repState == result ? 1 : 0) != 0);
                out.reset();
                in.reset();
            }
        }
        catch (Exception ex) {
            Assert.fail((String)"testReadWrite ex error ReplicaState");
        }
    }

    @Test
    public void testRemoteAddr() {
        Assert.assertEquals((Object)clientAddr, (Object)this.getRemoteAddr(clientAddr, null, false));
    }

    @Test
    public void testRemoteAddrWithUntrustedProxy() {
        Assert.assertEquals((Object)proxyAddr, (Object)this.getRemoteAddr(clientAddr, proxyAddr, false));
    }

    @Test
    public void testRemoteAddrWithTrustedProxy() {
        Assert.assertEquals((Object)clientAddr, (Object)this.getRemoteAddr(clientAddr, proxyAddr, true));
        Assert.assertEquals((Object)clientAddr, (Object)this.getRemoteAddr(chainedClientAddr, proxyAddr, true));
    }

    @Test
    public void testRemoteAddrWithTrustedProxyAndEmptyClient() {
        Assert.assertEquals((Object)proxyAddr, (Object)this.getRemoteAddr(null, proxyAddr, true));
        Assert.assertEquals((Object)proxyAddr, (Object)this.getRemoteAddr("", proxyAddr, true));
    }

    private String getRemoteAddr(String clientAddr, String proxyAddr, boolean trusted) {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)"1.2.3.4");
        Configuration conf = new Configuration();
        if (proxyAddr == null) {
            Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)clientAddr);
        } else {
            Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)proxyAddr);
            Mockito.when((Object)req.getHeader("X-Forwarded-For")).thenReturn((Object)clientAddr);
            if (trusted) {
                conf.set("hadoop.proxyservers", proxyAddr);
            }
        }
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        return JspHelper.getRemoteAddr((HttpServletRequest)req);
    }

    public static class DummySecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        public DummySecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        public DelegationTokenIdentifier createIdentifier() {
            return null;
        }

        public byte[] createPassword(DelegationTokenIdentifier dtId) {
            return new byte[1];
        }
    }
}

