/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestListPathServlet {
    private static final Configuration CONF = new HdfsConfiguration();
    private static MiniDFSCluster cluster;
    private static FileSystem fs;
    private static URI hftpURI;
    private static HftpFileSystem hftpFs;
    private final Random r = new Random();
    private final List<String> filelist = new ArrayList<String>();

    @BeforeClass
    public static void setup() throws Exception {
        cluster = new MiniDFSCluster.Builder(CONF).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        String str = "hftp://" + CONF.get("dfs.namenode.http-address");
        hftpURI = new URI(str);
        hftpFs = cluster.getHftpFileSystem(0);
    }

    @AfterClass
    public static void teardown() {
        cluster.shutdown();
    }

    private void createFile(String fileName, long fileLen) throws IOException {
        this.filelist.add(hftpURI + fileName);
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile(fs, filePath, fileLen, (short)1, this.r.nextLong());
    }

    private void mkdirs(String dirName) throws IOException {
        this.filelist.add(hftpURI + dirName);
        fs.mkdirs(new Path(dirName));
    }

    @Test
    public void testListStatus() throws Exception {
        this.checkStatus("/");
        this.createFile("/a", 1L);
        this.createFile("/b", 1L);
        this.mkdirs("/dir");
        this.checkFile(new Path("/a"));
        this.checkFile(new Path("/b"));
        this.checkStatus("/");
        this.createFile("/dir/.a.crc", 1L);
        this.createFile("/dir/b", 1L);
        this.mkdirs("/dir/dir1");
        this.checkFile(new Path("/dir/.a.crc"));
        this.checkFile(new Path("/dir/b"));
        this.checkStatus("/dir");
        this.checkStatus("/nonexistent");
        this.checkStatus("/nonexistent/a");
        String username = UserGroupInformation.getCurrentUser().getShortUserName() + "1";
        HftpFileSystem hftp2 = cluster.getHftpFileSystemAs(username, CONF, 0, "somegroup");
        Path nonexistent = new Path("/nonexistent");
        try {
            hftp2.getFileStatus(nonexistent);
            Assert.fail();
        }
        catch (IOException ioe) {
            FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
        }
        Path dir = new Path("/dir");
        fs.setPermission(dir, new FsPermission(0));
        try {
            hftp2.getFileStatus(new Path(dir, "a"));
            Assert.fail();
        }
        catch (IOException ioe) {
            FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
        }
    }

    private void checkStatus(String listdir) throws IOException {
        Path listpath = hftpFs.makeQualified(new Path(listdir));
        listdir = listpath.toString();
        FileStatus[] statuslist = hftpFs.listStatus(listpath);
        for (String directory : this.filelist) {
            System.out.println("dir:" + directory);
        }
        for (String file : this.filelist) {
            System.out.println("file:" + file);
        }
        for (FileStatus status : statuslist) {
            System.out.println("status:" + status.getPath().toString() + " type " + (status.isDirectory() ? "directory" : (status.isFile() ? "file" : "symlink")));
        }
        for (String file : this.filelist) {
            boolean found = false;
            if (!file.startsWith(listpath.toString()) || file.equals(listpath.toString())) continue;
            for (FileStatus status : statuslist) {
                if (!status.getPath().toString().equals(file)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Directory/file not returned in list status " + file), (boolean)found);
        }
    }

    private void checkFile(Path f) throws IOException {
        Path hdfspath = fs.makeQualified(f);
        FileStatus hdfsstatus = fs.getFileStatus(hdfspath);
        FileSystem.LOG.info((Object)("hdfspath=" + hdfspath));
        Path hftppath = hftpFs.makeQualified(f);
        FileStatus hftpstatus = hftpFs.getFileStatus(hftppath);
        FileSystem.LOG.info((Object)("hftppath=" + hftppath));
        Assert.assertEquals((Object)hdfspath.toUri().getPath(), (Object)hdfsstatus.getPath().toUri().getPath());
        TestListPathServlet.checkFileStatus(hdfsstatus, hftpstatus);
    }

    private static void checkFileStatus(FileStatus expected, FileStatus computed) {
        Assert.assertEquals((Object)expected.getPath().toUri().getPath(), (Object)computed.getPath().toUri().getPath());
        Assert.assertEquals((long)expected.getBlockSize(), (long)computed.getBlockSize());
        Assert.assertEquals((Object)expected.getGroup(), (Object)computed.getGroup());
        Assert.assertEquals((long)expected.getLen(), (long)computed.getLen());
        Assert.assertEquals((Object)expected.getOwner(), (Object)computed.getOwner());
        Assert.assertEquals((Object)expected.getPermission(), (Object)computed.getPermission());
        Assert.assertEquals((long)expected.getReplication(), (long)computed.getReplication());
    }
}

