/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.StorageSize;
import org.apache.hadoop.hbase.StorageUnit;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestStorageSize {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStorageSize.class);

    @Test
    public void testParse() {
        StorageSize size = StorageSize.parse((String)"20m");
        Assert.assertEquals((Object)StorageUnit.MB, (Object)size.getUnit());
        Assert.assertEquals((double)20.0, (double)size.getValue(), (double)1.0E-4);
        size = StorageSize.parse((String)"40mb");
        Assert.assertEquals((Object)StorageUnit.MB, (Object)size.getUnit());
        Assert.assertEquals((double)40.0, (double)size.getValue(), (double)1.0E-4);
        size = StorageSize.parse((String)"60megabytes");
        Assert.assertEquals((Object)StorageUnit.MB, (Object)size.getUnit());
        Assert.assertEquals((double)60.0, (double)size.getValue(), (double)1.0E-4);
        size = StorageSize.parse((String)"10g");
        Assert.assertEquals((Object)StorageUnit.GB, (Object)size.getUnit());
        Assert.assertEquals((double)10.0, (double)size.getValue(), (double)1.0E-4);
        size = StorageSize.parse((String)"30gb");
        Assert.assertEquals((Object)StorageUnit.GB, (Object)size.getUnit());
        Assert.assertEquals((double)30.0, (double)size.getValue(), (double)1.0E-4);
        size = StorageSize.parse((String)"50gigabytes");
        Assert.assertEquals((Object)StorageUnit.GB, (Object)size.getUnit());
        Assert.assertEquals((double)50.0, (double)size.getValue(), (double)1.0E-4);
    }

    @Test
    public void testGetStorageSize() {
        Assert.assertEquals((double)4194304.0, (double)StorageSize.getStorageSize((String)"4m", (double)-1.0, (StorageUnit)StorageUnit.BYTES), (double)1.0E-4);
        Assert.assertEquals((double)6144.0, (double)StorageSize.getStorageSize((String)"6g", (double)-1.0, (StorageUnit)StorageUnit.MB), (double)1.0E-4);
        Assert.assertEquals((double)-1.0, (double)StorageSize.getStorageSize(null, (double)-1.0, (StorageUnit)StorageUnit.BYTES), (double)1.0E-4);
        Assert.assertEquals((double)-2.0, (double)StorageSize.getStorageSize((String)"", (double)-2.0, (StorageUnit)StorageUnit.BYTES), (double)1.0E-4);
    }
}

