/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ResourceAllocationRequest;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDefinitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceAllocationInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReservationInfo {
    @XmlElement(name="acceptance-time")
    private long acceptanceTime;
    private String user;
    @XmlElement(name="resource-allocations")
    private List<ResourceAllocationInfo> resourceAllocations = new ArrayList<ResourceAllocationInfo>();
    @XmlElement(name="reservation-id")
    private String reservationId;
    @XmlElement(name="reservation-definition")
    private ReservationDefinitionInfo reservationDefinition;

    public ReservationInfo() {
        this.acceptanceTime = 0L;
        this.user = "";
        this.reservationDefinition = new ReservationDefinitionInfo();
    }

    public ReservationInfo(ReservationAllocationState allocation, boolean includeResourceAllocations) throws Exception {
        this.acceptanceTime = allocation.getAcceptanceTime();
        this.user = allocation.getUser();
        if (includeResourceAllocations) {
            List requests = allocation.getResourceAllocationRequests();
            for (ResourceAllocationRequest request : requests) {
                this.resourceAllocations.add(new ResourceAllocationInfo(new ReservationInterval(request.getStartTime(), request.getEndTime()), request.getCapability()));
            }
        }
        this.reservationId = allocation.getReservationId().toString();
        this.reservationDefinition = new ReservationDefinitionInfo(allocation.getReservationDefinition());
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String newUser) {
        this.user = newUser;
    }

    public long getAcceptanceTime() {
        return this.acceptanceTime;
    }

    public List<ResourceAllocationInfo> getResourceAllocations() {
        return this.resourceAllocations;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public ReservationDefinitionInfo getReservationDefinition() {
        return this.reservationDefinition;
    }
}

