/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourcesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.UsersInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CapacitySchedulerLeafQueueInfo
extends CapacitySchedulerQueueInfo {
    protected int numActiveApplications;
    protected int numPendingApplications;
    protected int numContainers;
    protected int maxApplications;
    protected int maxApplicationsPerUser;
    protected int userLimit;
    protected UsersInfo users;
    protected float userLimitFactor;
    protected ResourceInfo AMResourceLimit;
    protected ResourceInfo usedAMResource;
    protected ResourceInfo userAMResourceLimit;
    protected boolean preemptionDisabled;
    protected boolean intraQueuePreemptionDisabled;
    protected String defaultNodeLabelExpression;
    protected int defaultPriority;
    @XmlTransient
    protected String orderingPolicyInfo;

    CapacitySchedulerLeafQueueInfo() {
    }

    CapacitySchedulerLeafQueueInfo(LeafQueue q) {
        super(q);
        this.numActiveApplications = q.getNumActiveApplications();
        this.numPendingApplications = q.getNumPendingApplications();
        this.numContainers = q.getNumContainers();
        this.maxApplications = q.getMaxApplications();
        this.maxApplicationsPerUser = q.getMaxApplicationsPerUser();
        this.userLimit = q.getUserLimit();
        this.users = new UsersInfo(q.getUsersManager().getUsersInfo());
        this.userLimitFactor = q.getUserLimitFactor();
        this.AMResourceLimit = new ResourceInfo(q.getAMResourceLimit());
        this.usedAMResource = new ResourceInfo(q.getQueueResourceUsage().getAMUsed());
        this.preemptionDisabled = q.getPreemptionDisabled();
        this.intraQueuePreemptionDisabled = q.getIntraQueuePreemptionDisabled();
        this.orderingPolicyInfo = q.getOrderingPolicy().getInfo();
        this.defaultNodeLabelExpression = q.getDefaultNodeLabelExpression();
        this.defaultPriority = q.getDefaultApplicationPriority().getPriority();
        ArrayList<UserInfo> usersList = this.users.getUsersList();
        this.userAMResourceLimit = usersList.isEmpty() ? this.resources.getPartitionResourceUsageInfo("").getAMLimit() : usersList.get(0).getResourceUsageInfo().getPartitionResourceUsageInfo("").getAMLimit();
    }

    @Override
    protected void populateQueueResourceUsage(ResourceUsage queueResourceUsage) {
        this.resources = new ResourcesInfo(queueResourceUsage);
    }

    @Override
    protected void populateQueueCapacities(QueueCapacities qCapacities) {
        this.capacities = new QueueCapacitiesInfo(qCapacities);
    }

    public int getNumActiveApplications() {
        return this.numActiveApplications;
    }

    public int getNumPendingApplications() {
        return this.numPendingApplications;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    public int getUserLimit() {
        return this.userLimit;
    }

    public UsersInfo getUsers() {
        return this.users;
    }

    public float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    public ResourceInfo getAMResourceLimit() {
        return this.AMResourceLimit;
    }

    public ResourceInfo getUsedAMResource() {
        return this.usedAMResource;
    }

    public ResourceInfo getUserAMResourceLimit() {
        return this.userAMResourceLimit;
    }

    public boolean getPreemptionDisabled() {
        return this.preemptionDisabled;
    }

    public boolean getIntraQueuePreemptionDisabled() {
        return this.intraQueuePreemptionDisabled;
    }

    public String getOrderingPolicyInfo() {
        return this.orderingPolicyInfo;
    }

    public String getDefaultNodeLabelExpression() {
        return this.defaultNodeLabelExpression;
    }

    public int getDefaultApplicationPriority() {
        return this.defaultPriority;
    }
}

